/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tools;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class FileSetTask
extends Task {
    protected final Function<FileSet, Iterable<File>> _filesetToFiles = new Function<FileSet, Iterable<File>>(){

        public Iterable<File> apply(FileSet fileset) {
            DirectoryScanner ds = fileset.getDirectoryScanner(FileSetTask.this.getProject());
            final File fromDir = fileset.getDir(FileSetTask.this.getProject());
            return Iterables.transform(Arrays.asList(ds.getIncludedFiles()), (Function)new Function<String, File>(){

                public File apply(String file) {
                    return new File(fromDir, file);
                }
            });
        }
    };
    protected List<FileSet> _filesets = Lists.newArrayList();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    protected Iterable<File> getFiles() {
        return Iterables.concat((Iterable)Iterables.transform(this._filesets, this._filesetToFiles));
    }
}

