/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing.filetree;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.export.util.SerializableWrapper;
import com.threerings.swing.filetree.FileTreeNode;
import com.threerings.util.ToolUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class FileTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private String _treeName;
    protected File[] _groups;
    protected Set<String> _expanded = Sets.newHashSet();
    protected FileFilter _filter;
    protected FileFilter _searchFilter;
    protected String _lastFilterSelectedPath;
    protected static Preferences _prefs = Preferences.userNodeForPackage(FileTree.class);
    protected static final DataFlavor LOCAL_NODE_TRANSFER_FLAVOR = ToolUtil.createLocalFlavor(NodeTransfer.class);
    protected static final DataFlavor[] NODE_TRANSFER_FLAVORS = new DataFlavor[]{LOCAL_NODE_TRANSFER_FLAVOR, ToolUtil.SERIALIZED_WRAPPED_FLAVOR};

    public FileTree(String tree, FileFilter filter, File ... groups) {
        this(tree, filter, groups, false);
    }

    public FileTree(String tree, FileFilter filter, File group, boolean editable) {
        this(tree, filter, new File[]{group}, editable);
    }

    public void setSearchFilter(FileFilter filter) {
        if (this._searchFilter != filter) {
            this._searchFilter = filter;
            this.updateFiltered();
        }
    }

    public Transferable createClipboardTransferable() {
        FileTreeNode node = this.getSelectedNode();
        return node == null ? null : new NodeTransfer(node, true);
    }

    public FileTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path == null ? null : (FileTreeNode)path.getLastPathComponent();
    }

    public void setSelectedNode(String name) {
        if (name == null) {
            this.clearSelection();
            return;
        }
        FileTreeNode node = ((FileTreeNode)this.getModel().getRoot()).getNode(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    protected FileTree(String treeName, FileFilter filter, File[] roots, boolean editable) {
        this._treeName = treeName;
        this._groups = roots;
        this._filter = filter;
        this.setModel(new DefaultTreeModel(new FileTreeNode(roots, this._searchFilter, filter), true){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                TreePath selection = FileTree.this.getSelectionPath();
                FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
                FileTreeNode parent = (FileTreeNode)node.getParent();
                this.removeNodeFromParent(node);
                node.setUserObject(newValue);
                this.insertNodeInto(node, parent, parent.getInsertionIndex(node));
                node.expandPaths(FileTree.this);
                FileTree.this.setSelectionPath(selection);
            }

            @Override
            public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
                super.insertNodeInto(child, parent, index);
            }

            @Override
            public void removeNodeFromParent(MutableTreeNode node) {
                FileTreeNode ctnode = (FileTreeNode)node;
                if (FileTree.this.removeExpanded(ctnode)) {
                    FileTree.this.writeExpanded();
                }
                super.removeNodeFromParent(node);
            }
        });
        this.setRootVisible(false);
        this.setEditable(editable);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                FileTreeNode node = (FileTreeNode)event.getPath().getLastPathComponent();
                node.setExpanded(true);
                if (!FileTree.this.isSearched()) {
                    FileTree.this.addExpanded(node.getName());
                }
                node.expandPaths(FileTree.this);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                FileTreeNode node = (FileTreeNode)event.getPath().getLastPathComponent();
                node.setExpanded(false);
                if (!FileTree.this.isSearched()) {
                    FileTree.this.removeExpanded(node.getName());
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent comp) {
                return FileTree.this.isEditable() ? 2 : 1;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return FileTree.this.isEditable() && ListUtil.contains((Object[])flavors, (Object)ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                FileTreeNode node;
                Object data;
                if (!this.canImport(comp, t.getTransferDataFlavors())) {
                    return false;
                }
                boolean local = t.isDataFlavorSupported(LOCAL_NODE_TRANSFER_FLAVOR);
                try {
                    data = t.getTransferData(local ? LOCAL_NODE_TRANSFER_FLAVOR : ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)"Failure importing data.", new Object[]{e});
                    return false;
                }
                FileTreeNode onode = null;
                if (local) {
                    NodeTransfer transfer = (NodeTransfer)data;
                    node = transfer.cnode;
                    onode = transfer.onode;
                } else {
                    if (!((data = ((SerializableWrapper)data).getObject()) instanceof FileTreeNode)) {
                        return false;
                    }
                    node = (FileTreeNode)data;
                }
                FileTreeNode snode = FileTree.this.getSelectedNode();
                FileTreeNode parent = (FileTreeNode)FileTree.this.getModel().getRoot();
                if (snode != null && snode.getParent() != null) {
                    FileTreeNode fileTreeNode = parent = snode.getAllowsChildren() ? snode : (FileTreeNode)snode.getParent();
                }
                if (onode == parent || onode != null && onode.getParent() == parent) {
                    return false;
                }
                node = (FileTreeNode)node.clone();
                if (onode != null && onode.getRoot() == parent.getRoot()) {
                    ((DefaultTreeModel)FileTree.this.getModel()).removeNodeFromParent(onode);
                }
                ((DefaultTreeModel)FileTree.this.getModel()).insertNodeInto(node, parent, parent.getInsertionIndex(node));
                node.expandPaths(FileTree.this);
                FileTree.this.setSelectionPath(new TreePath(node.getPath()));
                return true;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                FileTreeNode node = FileTree.this.getSelectedNode();
                return node == null ? null : new NodeTransfer(node, false);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                FileTreeNode onode;
                if (action == 2 && (onode = ((NodeTransfer)data).onode).getParent() != null) {
                    ((DefaultTreeModel)FileTree.this.getModel()).removeNodeFromParent(onode);
                }
            }
        });
        this.setSearchFilter(null);
        this.pruneExpanded();
    }

    protected void updateFiltered() {
        FileTreeNode newSelect;
        FileTreeNode selected = this.getSelectedNode();
        if (selected != null) {
            this._lastFilterSelectedPath = selected.getName();
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        FileTreeNode root = new FileTreeNode(this._groups, this._filter, this._searchFilter);
        model.setRoot(root);
        model.reload();
        if (this._expanded.isEmpty()) {
            root.expandPaths(this, 1);
        } else if (this.isSearched()) {
            root.expandPaths(this, Integer.MAX_VALUE);
        } else {
            for (String name : this._expanded) {
                FileTreeNode node = root.getNode(name);
                if (node == null) continue;
                node.setExpanded(true);
                this.expandPath(new TreePath(node.getPath()));
            }
        }
        if (this._lastFilterSelectedPath != null && (newSelect = root.getNode(this._lastFilterSelectedPath)) != null) {
            TreePath path = new TreePath(newSelect.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    protected boolean isSearched() {
        return this._searchFilter != null;
    }

    protected void selectedConfigUpdated() {
    }

    protected void addExpanded(String name) {
        if (this._expanded.add(name)) {
            this.writeExpanded();
        }
    }

    protected boolean removeExpanded(FileTreeNode node) {
        boolean changed = this._expanded.remove(node.getName());
        int nn = node.getChildCount();
        for (int ii = 0; ii < nn; ++ii) {
            changed |= this.removeExpanded((FileTreeNode)node.getChildAt(ii));
        }
        return changed;
    }

    protected void removeExpanded(String name) {
        if (this._expanded.remove(name)) {
            this.writeExpanded();
        }
    }

    protected void readExpanded() {
        String names = _prefs.get(this._treeName + ".expanded", null);
        if (names != null) {
            this._expanded.addAll(Arrays.asList(StringUtil.parseStringArray((String)names)));
        }
    }

    protected void pruneExpanded() {
        FileTreeNode root = (FileTreeNode)this.getModel().getRoot();
        Iterator<String> it = this._expanded.iterator();
        while (it.hasNext()) {
            if (null != root.getNode(it.next())) continue;
            it.remove();
        }
    }

    protected void writeExpanded() {
        Object[] names = (String[])Iterables.toArray(this._expanded, String.class);
        String value = StringUtil.joinEscaped((String[])names);
        if (value.length() > 8192) {
            ClydeLog.log.warning((Object)"Too many expanded paths to store in preferences, trimming.", new Object[]{"group", this._treeName, "length", value.length()});
            Arrays.sort(names, Ordering.natural().onResultOf((Function)new Function<String, Integer>(){

                public Integer apply(String s) {
                    return Collections.frequency(Lists.charactersOf((String)s), Character.valueOf('/'));
                }
            }));
            while ((value = StringUtil.joinEscaped((String[])(names = (String[])ArrayUtil.splice((Object[])names, (int)(names.length - 1))))).length() > 8192) {
            }
        }
        _prefs.put(this._treeName + ".expanded", value);
    }

    protected static class NodeTransfer
    implements Transferable {
        public FileTreeNode onode;
        public FileTreeNode cnode;

        public NodeTransfer(FileTreeNode onode, boolean clipboard) {
            this.onode = clipboard ? null : onode;
            this.cnode = (FileTreeNode)onode.clone();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return NODE_TRANSFER_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ListUtil.contains((Object[])NODE_TRANSFER_FLAVORS, (Object)flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return flavor.equals(LOCAL_NODE_TRANSFER_FLAVOR) ? this : new SerializableWrapper(this.cnode);
        }
    }
}

