/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing.filetree;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.event.DocumentAdapter;
import com.samskivert.util.StringUtil;
import com.threerings.swing.filetree.FileTree;
import com.threerings.util.MessageManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class FileFilterPanel
extends JPanel {
    protected FileTree _tree;
    protected JTextField _input;
    protected Action _clearAction = new AbstractAction("", UIManager.getIcon("InternalFrame.closeIcon")){
        {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileFilterPanel.this.clearFilter();
        }
    };
    protected Predicate<File> _filter = null;
    protected List<Predicate<? super File>> _predicates;
    protected DocumentAdapter _inputListener = new DocumentAdapter(){

        public void documentChanged() {
            final String text = FileFilterPanel.this._input.getText().trim().toLowerCase();
            FileFilterPanel.this._filter = "".equals(text) ? null : new Predicate<File>(){

                public boolean apply(File cfg) {
                    return cfg.getName().toLowerCase().contains(text);
                }
            };
            FileFilterPanel.this.setFilter();
            FileFilterPanel.this._clearAction.setEnabled(FileFilterPanel.this._filter != null);
            FileFilterPanel.this._input.validate();
        }
    };

    public FileFilterPanel(MessageManager msgmgr) {
        super((LayoutManager)new VGroupLayout());
        ((VGroupLayout)this.getLayout()).setOffAxisPolicy(GroupLayout.STRETCH);
        this._input = new JTextField();
        this._input.getDocument().addDocumentListener((DocumentListener)this._inputListener);
        JPanel box = GroupLayout.makeHBox((GroupLayout.Policy)HGroupLayout.STRETCH);
        box.add((Component)new JLabel(msgmgr.getBundle("editor.config").get("l.filter_config")), HGroupLayout.FIXED);
        box.add(this._input);
        box.add((Component)new JButton(this._clearAction), HGroupLayout.FIXED);
        this.add(box);
    }

    public FileFilterPanel addConstraint(String description, final Predicate<? super File> filter, boolean removable) {
        if (this._predicates == null) {
            this._predicates = Lists.newArrayList();
        }
        this._predicates.add(filter);
        final JPanel box = GroupLayout.makeHBox((GroupLayout.Policy)HGroupLayout.STRETCH);
        AbstractAction clear = new AbstractAction("", UIManager.getIcon("InternalFrame.closeIcon")){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileFilterPanel.this.remove(box);
                FileFilterPanel.this._predicates.remove(filter);
                FileFilterPanel.this.setFilter();
            }
        };
        clear.setEnabled(removable);
        box.add(new JLabel(description));
        box.add((Component)new JButton(clear), HGroupLayout.FIXED);
        this.add((Component)box, this.getComponentCount() - 1);
        return this;
    }

    public void clearFilter() {
        this._input.setText("");
    }

    public void setTree(FileTree tree) {
        this._tree = tree;
        this.setFilter();
    }

    protected void setFilter() {
        if (this._tree != null) {
            this._tree.setSearchFilter(this.createFilter());
        }
    }

    protected FileFilter createFilter() {
        String input = this._input.getText().trim().toLowerCase();
        if (StringUtil.isBlank((String)input)) {
            return null;
        }
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean org = pathname != null && (pathname.isDirectory() || pathname.isFile() && pathname.getName() != null && pathname.getName().endsWith(".dat"));
                String input = FileFilterPanel.this._input.getText().trim().toLowerCase();
                if (StringUtil.isBlank((String)input)) {
                    return org;
                }
                return org && pathname.getName().toLowerCase().indexOf(input) >= 0;
            }
        };
    }
}

