/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleRenderable;

public abstract class SimpleTransformable
extends SimpleRenderable {
    protected Transform3D _transform = new Transform3D(2);

    public SimpleTransformable(GlContext ctx) {
        this(ctx, "Opaque");
    }

    public SimpleTransformable(GlContext ctx, String queue) {
        this(ctx, queue, 0);
    }

    public SimpleTransformable(GlContext ctx, String queue, int priority) {
        this(ctx, queue, priority, false, 0);
    }

    public SimpleTransformable(GlContext ctx, String queue, int priority, boolean modifiesColorState, int primitiveCount) {
        super(ctx, queue, priority, modifiesColorState, primitiveCount);
    }

    public Transform3D getTransform() {
        return this._transform;
    }

    @Override
    public void enqueue() {
        TransformState tstate = (TransformState)this._batch.getStates()[15];
        Transform3D modelview = tstate.getModelview();
        this._ctx.getCompositor().getCamera().getViewTransform().compose(this._transform, modelview);
        tstate.setDirty(true);
        this._batch.depth = modelview.transformPointZ(this.getCenter());
        super.enqueue();
    }

    @Override
    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[15] = new TransformState();
        return states;
    }

    protected SimpleTransformable() {
    }

    protected Vector3f getCenter() {
        return Vector3f.ZERO;
    }
}

