/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.google.common.collect.ImmutableMap;
import com.samskivert.util.ArrayUtil;
import com.threerings.opengl.Log;
import com.threerings.opengl.renderer.Program;
import com.threerings.opengl.renderer.Shader;
import com.threerings.opengl.renderer.ShaderObject;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.ResourceCache;
import com.threerings.util.CacheUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;

public class ShaderCache
extends ResourceCache {
    protected ResourceCache.Subcache<ShaderKey, Shader> _shaders = new ResourceCache.Subcache<ShaderKey, Shader>(){

        @Override
        protected Shader loadResource(ShaderKey key) {
            String path = key.path;
            String ext = path.substring(path.lastIndexOf(46) + 1);
            Integer type = TYPES.get(ext);
            if (type == null) {
                Log.log.warning((Object)"Unknown shader extension.", new Object[]{"path", path});
                return null;
            }
            StringBuilder buf = new StringBuilder();
            this.appendDefs(buf, key.defs);
            this.appendDefs(buf, key.ddefs);
            buf.append(ShaderCache.this.getSource(key.path));
            Shader shader = new Shader(ShaderCache.this._ctx.getRenderer(), type);
            if (!shader.setSource(buf.toString())) {
                Log.log.warning((Object)"Error compiling shader.", new Object[]{"defs", key.defs, "ddefs", key.ddefs, "path", path, "log", shader.getInfoLog()});
                return null;
            }
            ShaderCache.maybeCheckLog(shader, "defs", key.defs, "ddefs", key.ddefs, "path", path);
            return shader;
        }

        @Override
        protected String getResourcePath(ShaderKey key) {
            return key.path;
        }

        protected void appendDefs(StringBuilder buf, String[] defs) {
            for (String def : defs) {
                buf.append("#define ").append(def).append('\n');
            }
        }
    };
    protected ResourceCache.Subcache<String, String> _source = new ResourceCache.Subcache<String, String>(){

        @Override
        protected String loadResource(String path) {
            StringBuilder buf = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(ShaderCache.this._ctx.getResourceManager().getResource(path)));
                while ((line = reader.readLine()) != null) {
                    buf.append(line).append('\n');
                }
                reader.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to read shader source.", new Object[]{"path", path, e});
            }
            return buf.toString();
        }

        @Override
        protected String getResourcePath(String path) {
            return path;
        }
    };
    protected Map<ProgramKey, Program> _programs = CacheUtil.softValues();
    protected static final Map<String, Integer> TYPES = ImmutableMap.of((Object)"vert", (Object)35633, (Object)"frag", (Object)35632);
    protected static final boolean CHECK_LOGS = true;

    public ShaderCache(GlContext ctx, boolean checkTimestamps) {
        super(ctx, checkTimestamps);
    }

    public Shader getShader(String path, String ... defs) {
        return this.getShader(path, defs, ArrayUtil.EMPTY_STRING);
    }

    public Shader getShader(String path, String[] defs, String[] ddefs) {
        return this._shaders.getResource(new ShaderKey(path, defs, ddefs));
    }

    public String getSource(String path) {
        return this._source.getResource(path);
    }

    public Program getProgram(Shader vertex, Shader fragment) {
        ProgramKey key = new ProgramKey(vertex, fragment);
        Program program = this._programs.get(key);
        if (program == null) {
            program = new Program(this._ctx.getRenderer());
            if (!program.setShaders(vertex, fragment)) {
                Log.log.warning((Object)"Error linking shader program.", new Object[]{"vertex", vertex, "fragment", fragment, "log", program.getInfoLog()});
                return null;
            }
            ShaderCache.maybeCheckLog(program, "vertex", vertex, "fragment", fragment);
            this._programs.put(key, program);
        }
        return program;
    }

    protected static void maybeCheckLog(ShaderObject object, Object ... args) {
        String infolog = object.getInfoLog();
        if (infolog.length() > 255 || infolog.toLowerCase().contains("software")) {
            Log.log.warning((Object)"Possibly handling shader in software.", ArrayUtil.concatenate((Object[])args, (Object[])new Object[]{"log", infolog}));
        }
    }

    protected static class ProgramKey {
        protected WeakReference<Shader> _vertex;
        protected WeakReference<Shader> _fragment;

        public ProgramKey(Shader vertex, Shader fragment) {
            this._vertex = new WeakReference<Shader>(vertex);
            this._fragment = new WeakReference<Shader>(fragment);
        }

        public int hashCode() {
            return System.identityHashCode(this._vertex.get()) ^ System.identityHashCode(this._fragment.get());
        }

        public boolean equals(Object other) {
            ProgramKey okey = (ProgramKey)other;
            return this._vertex.get() == okey._vertex.get() && this._fragment.get() == okey._fragment.get();
        }
    }

    protected static class ShaderKey {
        public String path;
        public String[] defs;
        public String[] ddefs;

        public ShaderKey(String path, String[] defs, String[] ddefs) {
            this.path = path;
            this.defs = defs;
            this.ddefs = ddefs;
        }

        public int hashCode() {
            return this.path.hashCode() ^ Arrays.hashCode(this.defs);
        }

        public boolean equals(Object other) {
            ShaderKey okey = (ShaderKey)other;
            return this.path.equals(okey.path) && Arrays.equals(this.defs, okey.defs);
        }
    }
}

