/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import java.util.HashSet;
import java.util.List;

public class PreloadableSet
extends HashSet<Preloadable> {
    protected GlContext _ctx;
    protected List<Preloadable> _remaining;
    protected int _preloaded;

    public PreloadableSet(GlContext ctx) {
        this._ctx = ctx;
    }

    public float preloadBatch() {
        return this.preloadBatch(100L);
    }

    public float preloadBatch(long duration) {
        if (this._remaining != null && this._remaining.isEmpty()) {
            return 1.0f;
        }
        if (this._remaining == null) {
            this._remaining = Lists.newArrayList((Iterable)this);
        }
        long end = System.currentTimeMillis() + duration;
        for (int ii = this._remaining.size() - 1; ii >= 0 && System.currentTimeMillis() < end; --ii) {
            this._remaining.remove(ii).preload(this._ctx);
            ++this._preloaded;
        }
        if (this._remaining.isEmpty()) {
            return 1.0f;
        }
        return (float)this._preloaded / (float)this.size();
    }

    @Override
    public boolean add(Preloadable preloadable) {
        if (!super.add(preloadable)) {
            return false;
        }
        if (this._remaining != null) {
            preloadable.preload(this._ctx);
            ++this._preloaded;
        }
        return true;
    }

    public <T extends ManagedConfig> boolean addConfig(Class<T> clazz, String name) {
        return name != null && this.add(new Preloadable.Config(clazz, name));
    }

    public <T extends ManagedConfig> boolean addConfig(Class<T> clazz, ConfigReference<T> ref) {
        return ref != null && this.add(new Preloadable.Config(clazz, ref));
    }

    public boolean addModel(ConfigReference<ModelConfig> ref) {
        return ref != null && this.add(new Preloadable.Model(ref));
    }

    public boolean addAnim(ConfigReference<AnimationConfig> ref) {
        return ref != null && this.add(new Preloadable.Animation(ref));
    }
}

