/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.samskivert.util.ObjectUtil;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;

public abstract class Preloadable
extends DeepObject {
    public abstract void preload(GlContext var1);

    public static class Animation
    extends Preloadable {
        protected ConfigReference<AnimationConfig> _ref;

        public Animation(ConfigReference<AnimationConfig> ref) {
            this._ref = ref;
        }

        public ConfigReference<AnimationConfig> getReference() {
            return this._ref;
        }

        @Override
        public void preload(GlContext ctx) {
            AnimationConfig ani = ctx.getConfigManager().getConfig(AnimationConfig.class, this._ref);
            if (ani != null) {
                ani.preload(ctx);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Animation) {
                return ObjectUtil.equals(this._ref, ((Animation)other)._ref);
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this._ref == null) {
                return 0;
            }
            return this._ref.hashCode();
        }

        @Override
        public String toString() {
            return "[anim=" + this._ref + "]";
        }
    }

    public static class Model
    extends Preloadable {
        protected ConfigReference<ModelConfig> _ref;

        public Model(ConfigReference<ModelConfig> ref) {
            this._ref = ref;
        }

        public ConfigReference<ModelConfig> getReference() {
            return this._ref;
        }

        @Override
        public void preload(GlContext ctx) {
            ModelConfig conf = ctx.getConfigManager().getConfig(ModelConfig.class, this._ref);
            if (conf != null) {
                conf.preload(ctx);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Model) {
                return ObjectUtil.equals(this._ref, ((Model)other)._ref);
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this._ref == null) {
                return 0;
            }
            return this._ref.hashCode();
        }

        @Override
        public String toString() {
            return "[model=" + this._ref + "]";
        }
    }

    public static class Config
    extends Preloadable {
        protected Class<ManagedConfig> _clazz;
        protected ConfigReference<ManagedConfig> _ref;
        @DeepOmit
        protected ManagedConfig _config;

        public <T extends ManagedConfig> Config(Class<T> clazz, String name) {
            this(clazz, new ConfigReference(name));
        }

        public <T extends ManagedConfig> Config(Class<T> clazz, ConfigReference<T> ref) {
            Class<T> mclazz = clazz;
            this._clazz = mclazz;
            ConfigReference<T> mref = ref;
            this._ref = mref;
        }

        public Class<ManagedConfig> getConfigClass() {
            return this._clazz;
        }

        public ConfigReference<ManagedConfig> getReference() {
            return this._ref;
        }

        @Override
        public void preload(GlContext ctx) {
            this._config = ctx.getConfigManager().getConfig(this._clazz, this._ref);
            if (this._config != null && this._config instanceof LoadableConfig) {
                ((LoadableConfig)((Object)this._config)).preload(ctx);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Config) {
                return ObjectUtil.equals(this._ref, ((Config)other)._ref);
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this._ref == null) {
                return 0;
            }
            return this._ref.hashCode();
        }

        @Override
        public String toString() {
            return "[" + ConfigGroup.getName(this._clazz) + "=" + this._ref + "]";
        }
    }

    public static interface LoadableConfig {
        public void preload(GlContext var1);
    }
}

