/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.Updater;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector4f;
import com.threerings.opengl.material.Projection;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.config.ColorStateConfig;
import com.threerings.opengl.renderer.config.LightConfig;
import com.threerings.opengl.scene.LightInfluence;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.ShallowObject;
import java.util.ArrayList;

@EditorTypes(value={Texture.class})
public abstract class ShadowConfig
extends DeepObject
implements Exportable {
    public abstract SceneInfluence createInfluence(GlContext var1, Scope var2, LightConfig var3, Light var4, ArrayList<Updater> var5);

    protected static String getProjectionScheme(Light.Type type) {
        switch (type) {
            case DIRECTIONAL: {
                return "Projection (STR)";
            }
            case POINT: {
                return "Projection (STR)";
            }
            case SPOT: {
                return "Projection (STRQ)";
            }
        }
        return null;
    }

    public static class TextureData
    extends Data {
        public Transform3D transform = new Transform3D();
        public float near;
        public float far;
        public float width;
        public float height;
        public float depth;
    }

    public static abstract class Data
    extends ShallowObject {
        public Light light;
        public Updater updater;
    }

    public static class Texture
    extends ShadowConfig {
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float near = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float far = 100.0f;
        @Editable(nullable=true)
        public ConfigReference<MaterialConfig> material;
        @Editable(nullable=true)
        public ColorStateConfig colorState = new ColorStateConfig();

        @Override
        public SceneInfluence createInfluence(final GlContext ctx, Scope scope, LightConfig lightConfig, final Light viewLight, ArrayList<Updater> updaters) {
            TechniqueConfig technique;
            MaterialConfig mconfig = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            Light.Type lightType = viewLight.getType();
            TechniqueConfig techniqueConfig = technique = mconfig == null ? null : mconfig.getTechnique(ctx, Texture.getProjectionScheme(lightType));
            if (technique == null) {
                return new LightInfluence(viewLight);
            }
            final TextureData data = new TextureData();
            data.near = this.near;
            data.far = this.far;
            ArrayList<Updater> worldUpdaters = new ArrayList<Updater>(1);
            data.light = lightConfig.createLight(ctx, scope, true, worldUpdaters);
            data.updater = worldUpdaters.get(0);
            final Projection projection = new Projection(technique, this.colorState == null ? null : this.colorState.getState()){
                @Scoped
                protected TextureData _data;
                {
                    super(technique, colorState);
                    this._data = data;
                }
            };
            if (lightType == Light.Type.DIRECTIONAL) {
                updaters.add(new Updater(){
                    protected Transform3D _viewTransformInv = new Transform3D();

                    @Override
                    public void update() {
                        ctx.getCompositor().getCamera().getViewTransform().compose(data.transform, this._viewTransformInv);
                        this._viewTransformInv.invertLocal().update(3);
                        Matrix4f mat = this._viewTransformInv.getMatrix();
                        float ss = 1.0f / data.width;
                        projection.getGenPlaneS().set(ss * mat.m00, ss * mat.m10, ss * mat.m20, ss * mat.m30 + 0.5f);
                        float ts = 1.0f / data.height;
                        projection.getGenPlaneT().set(ts * mat.m01, ts * mat.m11, ts * mat.m21, ts * mat.m31 + 0.5f);
                        float rs = -1.0f / data.depth;
                        projection.getGenPlaneR().set(rs * mat.m02, rs * mat.m12, rs * mat.m22, rs * mat.m32);
                    }
                });
            } else if (lightType == Light.Type.POINT) {
                updaters.add(new Updater(){
                    protected Transform3D _viewTransformInv = new Transform3D();

                    @Override
                    public void update() {
                        ctx.getCompositor().getCamera().getViewTransform().compose(data.transform, this._viewTransformInv);
                        this._viewTransformInv.invertLocal().update(3);
                        Matrix4f mat = this._viewTransformInv.getMatrix();
                        projection.getGenPlaneS().set(mat.m00, mat.m10, mat.m20, mat.m30);
                        projection.getGenPlaneT().set(mat.m01, mat.m11, mat.m21, mat.m31);
                        projection.getGenPlaneR().set(mat.m02, mat.m12, mat.m22, mat.m32);
                    }
                });
            } else {
                updaters.add(new Updater(){
                    protected Transform3D _viewTransformInv = new Transform3D();

                    @Override
                    public void update() {
                        ctx.getCompositor().getCamera().getViewTransform().compose(data.transform, this._viewTransformInv);
                        this._viewTransformInv.invertLocal().update(3);
                        Matrix4f mat = this._viewTransformInv.getMatrix();
                        Vector4f gpq = projection.getGenPlaneQ();
                        gpq.set(-mat.m02, -mat.m12, -mat.m22, -mat.m32);
                        float ss = 0.5f / FloatMath.tan(FloatMath.toRadians(viewLight.spotCutoff));
                        projection.getGenPlaneS().set(ss * mat.m00 + 0.5f * gpq.x, ss * mat.m10 + 0.5f * gpq.y, ss * mat.m20 + 0.5f * gpq.z, ss * mat.m30 + 0.5f * gpq.w);
                        projection.getGenPlaneT().set(ss * mat.m01 + 0.5f * gpq.x, ss * mat.m11 + 0.5f * gpq.y, ss * mat.m21 + 0.5f * gpq.z, ss * mat.m31 + 0.5f * gpq.w);
                        float rs = far / (near - far);
                        projection.getGenPlaneR().set(rs * mat.m02, rs * mat.m12, rs * mat.m22, rs * mat.m32 + near * rs);
                    }
                });
            }
            return new LightInfluence(viewLight){

                @Override
                public Projection getProjection() {
                    return projection;
                }
            };
        }
    }
}

