/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene.config;

import com.google.common.collect.Lists;
import com.samskivert.util.Tuple;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.ExpressionDefinition;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.material.config.ProjectionConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.config.FogStateConfig;
import com.threerings.opengl.renderer.config.LightConfig;
import com.threerings.opengl.scene.AmbientLightInfluence;
import com.threerings.opengl.scene.DefinerInfluence;
import com.threerings.opengl.scene.FogInfluence;
import com.threerings.opengl.scene.LightInfluence;
import com.threerings.opengl.scene.ProjectorInfluence;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.opengl.scene.config.ShadowConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.ArrayList;

@EditorTypes(value={AmbientLight.class, Fog.class, Light.class, Projector.class, Definer.class})
public abstract class SceneInfluenceConfig
extends DeepObject
implements Exportable {
    @Editable(weight=1.0)
    public ExpressionBinding[] staticBindings = ExpressionBinding.EMPTY_ARRAY;
    @Editable(weight=1.0)
    public ExpressionBinding[] dynamicBindings = ExpressionBinding.EMPTY_ARRAY;

    public SceneInfluence createSceneInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
        SceneInfluence influence = this.createInfluence(ctx, scope, updaters);
        for (ExpressionBinding binding : this.staticBindings) {
            binding.createUpdater(ctx.getConfigManager(), scope, influence).update();
        }
        for (ExpressionBinding binding : this.dynamicBindings) {
            updaters.add(binding.createUpdater(ctx.getConfigManager(), scope, influence));
        }
        return influence;
    }

    public void invalidate() {
        for (ExpressionBinding binding : this.staticBindings) {
            binding.invalidate();
        }
        for (ExpressionBinding binding : this.dynamicBindings) {
            binding.invalidate();
        }
    }

    protected abstract SceneInfluence createInfluence(GlContext var1, Scope var2, ArrayList<Updater> var3);

    protected static SceneInfluence createNoopInfluence() {
        return new SceneInfluence(){};
    }

    public static class Definer
    extends SceneInfluenceConfig {
        @Editable
        public ExpressionDefinition[] definitions = new ExpressionDefinition[0];

        @Override
        public void invalidate() {
            super.invalidate();
            for (ExpressionDefinition definition : this.definitions) {
                definition.invalidate();
            }
        }

        @Override
        protected SceneInfluence createInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
            ArrayList list = Lists.newArrayList();
            for (ExpressionDefinition definition : this.definitions) {
                list.add(Tuple.newTuple((Object)definition.name, (Object)definition.getValue(scope, updaters)));
            }
            Tuple[] array = new Tuple[list.size()];
            return new DefinerInfluence(list.toArray(array));
        }
    }

    public static class Projector
    extends SceneInfluenceConfig {
        @Editable
        public ProjectionConfig projection = new ProjectionConfig.Perspective();

        @Override
        protected SceneInfluence createInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
            return new ProjectorInfluence(this.projection.createProjection(ctx, scope, updaters));
        }
    }

    public static class Light
    extends SceneInfluenceConfig {
        @Editable
        public LightConfig light = new LightConfig.Directional();
        @Editable(nullable=true)
        public ShadowConfig shadow;

        @Override
        protected SceneInfluence createInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
            if (!ScopeUtil.resolve(scope, "lightingEnabled", true).booleanValue()) {
                return Light.createNoopInfluence();
            }
            com.threerings.opengl.renderer.Light viewLight = this.light.createLight(ctx, scope, false, updaters);
            return this.shadow == null ? new LightInfluence(viewLight) : this.shadow.createInfluence(ctx, scope, this.light, viewLight, updaters);
        }
    }

    public static class Fog
    extends SceneInfluenceConfig {
        @Editable
        public FogStateConfig state = new FogStateConfig.Linear();

        @Override
        protected SceneInfluence createInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
            return ScopeUtil.resolve(scope, "fogEnabled", true) != false ? new FogInfluence(this.state.getState()) : Fog.createNoopInfluence();
        }
    }

    public static class AmbientLight
    extends SceneInfluenceConfig {
        @Editable
        public Color4f color = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);

        @Override
        protected SceneInfluence createInfluence(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
            return ScopeUtil.resolve(scope, "lightingEnabled", true) != false ? new AmbientLightInfluence(this.color) : AmbientLight.createNoopInfluence();
        }
    }
}

