/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.config.TextureUnitConfig;
import com.threerings.opengl.renderer.state.TextureState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.util.List;

public class TextureStateConfig
extends DeepObject
implements Exportable {
    @Editable
    public boolean uniqueInstance;
    @Editable
    public TextureUnitConfig[] units = new TextureUnitConfig[0];
    @DeepOmit
    protected transient SoftReference<TextureState> _instance;

    @Deprecated
    public void getUpdateReferences(ConfigReferenceSet refs) {
    }

    public boolean isSupported(GlContext ctx, boolean fallback) {
        if (this.units.length > ctx.getRenderer().getMaxTextureImageUnits()) {
            return false;
        }
        for (TextureUnitConfig unit : this.units) {
            if (unit.isSupported(ctx, fallback)) continue;
            return false;
        }
        return true;
    }

    public void populateDescriptor(PassDescriptor desc) {
        desc.texCoordSets = new int[this.units.length];
        for (int ii = 0; ii < this.units.length; ++ii) {
            TextureUnitConfig unit = this.units[ii];
            desc.texCoordSets[ii] = unit.coordSet;
            desc.normals = desc.normals | (unit.coordGenS != null && unit.coordGenS.usesNormals() || unit.coordGenT != null && unit.coordGenT.usesNormals() || unit.coordGenR != null && unit.coordGenR.usesNormals());
        }
    }

    public TextureState getState(GlContext ctx, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
        TextureState instance;
        if (this.units.length == 0) {
            return TextureState.DISABLED;
        }
        if (this.uniqueInstance) {
            return this.createInstance(ctx, scope, adders, updaters);
        }
        TextureState textureState = instance = this._instance == null ? null : this._instance.get();
        if (instance == null) {
            int esize = adders.size();
            int usize = updaters.size();
            instance = this.createInstance(ctx, scope, adders, updaters);
            if (adders.size() == esize && updaters.size() == usize) {
                this._instance = new SoftReference<TextureState>(instance);
            }
        }
        return instance;
    }

    public void invalidate() {
        this._instance = null;
    }

    protected TextureState createInstance(GlContext ctx, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
        TextureUnit[] sunits = new TextureUnit[this.units.length];
        TextureState state = new TextureState(sunits);
        for (int ii = 0; ii < this.units.length; ++ii) {
            sunits[ii] = this.units[ii].createUnit(ctx, state, scope, adders, updaters);
        }
        return state;
    }
}

