/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.PreparedEditable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.awt.Color;
import java.util.Arrays;

@EditorTypes(value={Normal.class, CustomOffsets.class, FullyCustom.class, Translated.class})
public abstract class ColorizationConfig
extends DeepObject
implements Exportable,
Streamable {
    public static CustomOffsets createConfig(int clazz, float hue, float saturation, float value) {
        CustomOffsets config = new CustomOffsets();
        config.clazz = clazz;
        config.offsets.hue = hue;
        config.offsets.saturation = saturation;
        config.offsets.value = value;
        return config;
    }

    public static Normal createConfig(int colorization) {
        Normal config = new Normal();
        config.colorization = colorization;
        return config;
    }

    public abstract Colorization getColorization(GlContext var1);

    public static class FullyCustomColorization
    extends Colorization {
        public FullyCustomColorization(Color source, float[] range, float[] offsets) {
            super(0, source, range, offsets);
        }

        public int hashCode() {
            return super.hashCode() ^ Arrays.hashCode(this.offsets);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!super.equals(other)) return false;
            Colorization ozation = (Colorization)other;
            if (!ozation.rootColor.equals(this.rootColor)) return false;
            if (!Arrays.equals(ozation.range, this.range)) return false;
            if (!Arrays.equals(ozation.offsets, this.offsets)) return false;
            return true;
        }
    }

    public static class CustomOffsetsColorization
    extends Colorization {
        public CustomOffsetsColorization(ColorPository.ClassRecord crec, float[] offsets) {
            super(crec.classId << 8, crec, offsets);
        }

        public CustomOffsetsColorization(ColorPository.ClassRecord target, Colorization source) {
            this(target, new float[3]);
            for (int ii = 0; ii < 3; ++ii) {
                this.offsets[ii] = source.offsets[ii] + (source.getRootHsv(ii) - this._hsv[ii]);
            }
        }

        public CustomOffsetsColorization(int clazz, Color source, float[] range, float[] offsets) {
            super(clazz << 8, source, range, offsets);
        }

        public int hashCode() {
            return super.hashCode() ^ Arrays.hashCode(this.offsets);
        }

        public boolean equals(Object other) {
            return super.equals(other) && Arrays.equals(this.offsets, ((Colorization)other).offsets);
        }
    }

    public static class Triplet
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable(min=-1.0, max=1.0, step=0.001, hgroup="v")
        public float hue;
        @Editable(min=-1.0, max=1.0, step=0.001, hgroup="v")
        public float saturation;
        @Editable(min=-1.0, max=1.0, step=0.001, hgroup="v")
        public float value;

        public float[] getValues() {
            return new float[]{this.hue, this.saturation, this.value};
        }
    }

    public static class Translated
    extends ColorizationConfig
    implements PreparedEditable {
        @Editable(editor="colorization", mode="class")
        public int clazz;
        @Editable
        public ColorizationConfig source = new Normal();

        @Override
        public Colorization getColorization(GlContext ctx) {
            ColorPository colorpos = ctx.getColorPository();
            ColorPository.ClassRecord crec = colorpos.getClassRecord(this.clazz);
            Colorization src = this.source == null ? null : this.source.getColorization(ctx);
            return src == null || crec == null ? null : new CustomOffsetsColorization(crec, src);
        }

        @Override
        public void prepareInstanceToEdit() {
            if (this.source == null) {
                this.source = new Normal();
            }
        }

        public Translated() {
        }

        public Translated(Normal normal) {
            this.clazz = normal.colorization >> 8;
            this.source = normal;
        }
    }

    public static class FullyCustom
    extends ColorizationConfig {
        @Editable
        public Color4f source = new Color4f();
        @Editable
        public Triplet range = new Triplet();
        @Editable
        public Triplet offsets = new Triplet();

        @Override
        public Colorization getColorization(GlContext ctx) {
            return new FullyCustomColorization(this.source.getColor(), this.range.getValues(), this.offsets.getValues());
        }
    }

    public static class CustomOffsets
    extends ColorizationConfig {
        @Editable(editor="colorization", mode="class")
        public int clazz;
        @Editable
        public Triplet offsets = new Triplet();

        @Override
        public Colorization getColorization(GlContext ctx) {
            ColorPository.ClassRecord crec = ctx.getColorPository().getClassRecord(this.clazz);
            return crec == null ? null : new CustomOffsetsColorization(this.clazz, crec.source, crec.range, this.offsets.getValues());
        }
    }

    public static class Normal
    extends ColorizationConfig {
        @Editable(editor="colorization")
        public int colorization;

        @Override
        public Colorization getColorization(GlContext ctx) {
            return ctx.getColorPository().getColorization(this.colorization);
        }
    }
}

