/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.export.Exportable;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.util.DeepObject;
import java.nio.FloatBuffer;

public class ClientArrayConfig
extends DeepObject
implements Exportable {
    public int size;
    public Type type;
    public boolean normalized;
    public int stride;
    public int offset;
    public FloatBuffer floatArray;

    public ClientArrayConfig(int size) {
        this(size, null);
    }

    public ClientArrayConfig(int size, FloatBuffer floatArray) {
        this(size, 0, 0, floatArray);
    }

    public ClientArrayConfig(int size, int stride, int offset, FloatBuffer floatArray) {
        this.size = size;
        this.type = Type.FLOAT;
        this.stride = stride;
        this.offset = offset;
        this.floatArray = floatArray;
    }

    public ClientArrayConfig() {
    }

    public int getElementBytes() {
        return this.size * this.type.getBytes();
    }

    public boolean canMerge(ClientArrayConfig oarray) {
        return this.size == oarray.size && this.type == oarray.type && this.normalized == oarray.normalized;
    }

    public ClientArray createClientArray() {
        return new ClientArray(this.size, this.type.getConstant(), this.normalized, this.stride, this.offset, null, this.floatArray);
    }

    public void populateClientArray(ClientArray array) {
        FloatBuffer src = this.floatArray;
        FloatBuffer dest = array.floatArray;
        int sstride = this.stride / 4;
        int dstride = array.stride / 4;
        int sidx = this.offset / 4;
        int didx = (int)array.offset / 4;
        float[] value = new float[this.size];
        int nn = src.capacity() / sstride;
        for (int ii = 0; ii < nn; ++ii) {
            src.position(sidx);
            src.get(value);
            dest.position(didx);
            dest.put(value);
            sidx += sstride;
            didx += dstride;
        }
        src.rewind();
        dest.rewind();
    }

    public void populateFloatArray(float[] array, int doffset, int dstride) {
        FloatBuffer src = this.floatArray;
        int sstride = this.stride / 4;
        int sidx = this.offset / 4;
        int didx = doffset;
        int nn = src.capacity() / sstride;
        for (int ii = 0; ii < nn; ++ii) {
            src.position(sidx);
            src.get(array, didx, this.size);
            sidx += sstride;
            didx += dstride;
        }
        src.rewind();
    }

    public void populateIntArray(int[] array, int doffset, int dstride) {
        FloatBuffer src = this.floatArray;
        int sstride = this.stride / 4;
        int sidx = this.offset / 4;
        int didx = doffset;
        int nn = src.capacity() / sstride;
        for (int ii = 0; ii < nn; ++ii) {
            for (int jj = 0; jj < this.size; ++jj) {
                array[didx + jj] = (int)src.get(sidx + jj);
            }
            sidx += sstride;
            didx += dstride;
        }
        src.rewind();
    }

    public static enum Type {
        BYTE(5120, 1),
        UNSIGNED_BYTE(5121, 1),
        SHORT(5122, 2),
        UNSIGNED_SHORT(5123, 2),
        INT(5124, 4),
        UNSIGNED_INT(5125, 4),
        FLOAT(5126, 4),
        DOUBLE(5130, 8);

        protected final int _constant;
        protected final int _bytes;

        public int getConstant() {
            return this._constant;
        }

        public int getBytes() {
            return this._bytes;
        }

        private Type(int constant, int bytes) {
            this._constant = constant;
            this._bytes = bytes;
        }
    }
}

