/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;

public abstract class ShaderObject {
    protected Renderer _renderer;
    protected int _id;
    protected static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");

    public ShaderObject(Renderer renderer) {
        this._renderer = renderer;
    }

    public final int getId() {
        return this._id;
    }

    public String getInfoLog() {
        IntBuffer ibuf = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)this._id, (int)35716, (IntBuffer)ibuf);
        int length = ibuf.get(0);
        if (length <= 0) {
            return "";
        }
        ByteBuffer bbuf = BufferUtils.createByteBuffer((int)length);
        ARBShaderObjects.glGetInfoLogARB((int)this._id, (IntBuffer)ibuf, (ByteBuffer)bbuf);
        bbuf.limit(length);
        return ASCII_CHARSET.decode(bbuf).toString();
    }

    public void delete() {
        ARBShaderObjects.glDeleteObjectARB((int)this._id);
        this._id = 0;
        this._renderer.shaderObjectDeleted();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._renderer.shaderObjectFinalized(this._id);
        }
    }
}

