/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.BufferObject;
import java.nio.FloatBuffer;

public class ClientArray {
    public int size;
    public int type;
    public boolean normalized;
    public int stride;
    public long offset;
    public BufferObject arrayBuffer;
    public FloatBuffer floatArray;
    public boolean dirty;

    public ClientArray(int size, int type, BufferObject arrayBuffer) {
        this(size, type, 0, 0L, arrayBuffer);
    }

    public ClientArray(int size, int type, int stride, long offset, BufferObject arrayBuffer) {
        this(size, type, false, stride, offset, arrayBuffer, null);
    }

    public ClientArray(int size, FloatBuffer floatArray) {
        this(size, 0, 0L, floatArray);
    }

    public ClientArray(int size, int stride, long offset, FloatBuffer floatArray) {
        this(size, 5126, false, stride, offset, null, floatArray);
    }

    public ClientArray(int size, int type, boolean normalized, int stride, long offset, BufferObject arrayBuffer, FloatBuffer floatArray) {
        this.set(size, type, normalized, stride, offset, arrayBuffer, floatArray);
    }

    public ClientArray() {
    }

    public ClientArray set(ClientArray array) {
        return this.set(array.size, array.type, array.normalized, array.stride, array.offset, array.arrayBuffer, array.floatArray);
    }

    public ClientArray set(int size, int type, boolean normalized, int stride, long offset, BufferObject arrayBuffer, FloatBuffer floatArray) {
        this.size = size;
        this.type = type;
        this.normalized = normalized;
        this.stride = stride;
        this.offset = offset;
        this.arrayBuffer = arrayBuffer;
        this.floatArray = floatArray;
        return this;
    }

    public int getElementBytes() {
        return this.size * this.getComponentBytes();
    }

    public int getComponentBytes() {
        switch (this.type) {
            case 5120: 
            case 5121: {
                return 1;
            }
            case 5122: 
            case 5123: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        return -1;
    }

    public boolean equals(Object other) {
        ClientArray oarray = (ClientArray)other;
        return this.size == oarray.size && this.type == oarray.type && this.normalized == oarray.normalized && this.stride == oarray.stride && this.offset == oarray.offset && this.arrayBuffer == oarray.arrayBuffer && this.floatArray == oarray.floatArray;
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + this.type;
        result = 31 * result + (this.normalized ? 1 : 0);
        result = 31 * result + this.stride;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.arrayBuffer != null ? this.arrayBuffer.hashCode() : 0);
        result = 31 * result + (this.floatArray != null ? this.floatArray.hashCode() : 0);
        return result;
    }
}

