/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ComparableTuple;
import com.threerings.editor.Editable;
import com.threerings.expr.Scope;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.Static;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.model.tools.ModelDef;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepOmit;
import com.threerings.util.Shallow;
import java.lang.ref.SoftReference;
import java.util.TreeMap;
import java.util.TreeSet;
import proguard.annotation.Keep;

public class StaticSetConfig
extends ModelConfig.Imported {
    @Editable(editor="choice", depends={"source"})
    public String model;
    @Shallow
    public TreeMap<String, ModelConfig.MeshSet> meshes;
    @DeepOmit
    protected transient SoftReference<StaticConfig.Resolved> _resolved;

    @Keep
    public String[] getModelOptions() {
        return this.meshes == null || this.meshes.isEmpty() ? ArrayUtil.EMPTY_STRING : this.meshes.keySet().toArray(new String[this.meshes.size()]);
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        StaticConfig.Resolved resolved;
        StaticConfig.Resolved resolved2 = resolved = this._resolved == null ? null : this._resolved.get();
        if (resolved == null) {
            ModelConfig.MeshSet mset;
            ModelConfig.MeshSet meshSet = mset = this.model == null || this.meshes == null ? null : this.meshes.get(this.model);
            if (mset == null) {
                return null;
            }
            resolved = new StaticConfig.Resolved(mset.bounds, mset.collision, StaticSetConfig.getGeometryMaterials(ctx, mset.visible, this.materialMappings), this.influences.getFlags());
            this._resolved = new SoftReference<StaticConfig.Resolved>(resolved);
        }
        if (impl instanceof Static) {
            ((Static)impl).setConfig(ctx, resolved);
        } else {
            impl = new Static(ctx, scope, resolved);
        }
        return impl;
    }

    @Override
    public void invalidate() {
        this._resolved = null;
    }

    @Override
    protected ModelConfig.VisibleMesh getParticleMesh() {
        ModelConfig.MeshSet mset = this.model == null || this.meshes == null ? null : this.meshes.get(this.model);
        return mset == null || mset.visible.length == 0 ? null : mset.visible[0];
    }

    @Override
    protected void updateFromSource(ModelDef def) {
        if (def == null) {
            this.model = null;
            this.meshes = null;
        } else {
            def.update(this);
        }
    }

    @Override
    protected void getTextures(TreeSet<String> textures) {
        if (this.meshes != null) {
            for (ModelConfig.MeshSet set : this.meshes.values()) {
                set.getTextures(textures);
            }
        }
    }

    @Override
    protected void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
        if (this.meshes != null) {
            for (ModelConfig.MeshSet set : this.meshes.values()) {
                set.getTextureTagPairs(pairs);
            }
        }
    }
}

