/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.ComparableTuple;
import com.threerings.expr.Scope;
import com.threerings.math.Box;
import com.threerings.opengl.material.config.GeometryMaterial;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.Static;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.tools.ModelDef;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepOmit;
import com.threerings.util.Shallow;
import java.lang.ref.SoftReference;
import java.util.TreeSet;

public class StaticConfig
extends ModelConfig.Imported {
    @Shallow
    public ModelConfig.MeshSet meshes;
    @DeepOmit
    protected transient SoftReference<Resolved> _resolved;

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        Resolved resolved;
        if (this.meshes == null) {
            return null;
        }
        Resolved resolved2 = resolved = this._resolved == null ? null : this._resolved.get();
        if (resolved == null) {
            resolved = new Resolved(this.meshes.bounds, this.meshes.collision, StaticConfig.getGeometryMaterials(ctx, this.meshes.visible, this.materialMappings), this.influences.getFlags());
            this._resolved = new SoftReference<Resolved>(resolved);
        }
        if (impl instanceof Static) {
            ((Static)impl).setConfig(ctx, resolved);
        } else {
            impl = new Static(ctx, scope, resolved);
        }
        return impl;
    }

    @Override
    public void invalidate() {
        this._resolved = null;
    }

    @Override
    protected ModelConfig.VisibleMesh getParticleMesh() {
        return this.meshes == null || this.meshes.visible.length == 0 ? null : this.meshes.visible[0];
    }

    @Override
    protected void updateFromSource(ModelDef def) {
        if (def == null) {
            this.meshes = null;
        } else {
            def.update(this);
        }
    }

    @Override
    protected void getTextures(TreeSet<String> textures) {
        if (this.meshes != null) {
            this.meshes.getTextures(textures);
        }
    }

    @Override
    protected void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
        if (this.meshes != null) {
            this.meshes.getTextureTagPairs(pairs);
        }
    }

    public static class Resolved {
        public final Box bounds;
        public final CollisionMesh collision;
        public final GeometryMaterial[] gmats;
        public final int influenceFlags;

        public Resolved(Box bounds, CollisionMesh collision, GeometryMaterial[] gmats, int influenceFlags) {
            this.bounds = bounds;
            this.collision = collision;
            this.gmats = gmats;
            this.influenceFlags = influenceFlags;
        }
    }
}

