/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Scope;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.Conditional;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.InfluenceFlagConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;

public class ConditionalConfig
extends ModelConfig.Implementation {
    @Editable
    public SceneElement.TickPolicy tickPolicy = SceneElement.TickPolicy.DEFAULT;
    @Editable
    public InfluenceFlagConfig influences = new InfluenceFlagConfig(true);
    @Editable
    public Case[] cases = new Case[0];
    @Editable(nullable=true)
    public ConfigReference<ModelConfig> defaultModel;
    @Editable(step=0.01)
    public Transform3D defaultTransform = new Transform3D();

    @Override
    public void preload(GlContext ctx) {
        new Preloadable.Model(this.defaultModel).preload(ctx);
        for (Case condition : this.cases) {
            new Preloadable.Model(condition.model).preload(ctx);
        }
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        if (impl instanceof Conditional) {
            ((Conditional)impl).setConfig(ctx, this);
        } else {
            impl = new Conditional(ctx, scope, this);
        }
        return impl;
    }

    @Override
    public void invalidate() {
        for (Case caze : this.cases) {
            caze.condition.invalidate();
        }
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable
        public BooleanExpression condition = new BooleanExpression.Constant(true);
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();
    }
}

