/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.RandomUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.DisposalExcutor;
import com.threerings.expr.Executor;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.openal.Sounder;
import com.threerings.openal.config.SounderConfig;
import com.threerings.openal.util.AlContext;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.AnimationObserver;
import com.threerings.opengl.model.Articulated;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlContextWrapper;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;

@EditorTypes(value={CallFunction.class, SpawnTransient.class, PlaySound.class, ShakeCamera.class, Conditional.class, Compound.class, Random.class})
public abstract class ActionConfig
extends DeepObject
implements Exportable {
    public abstract Executor createExecutor(GlContext var1, Scope var2);

    public abstract void preload(GlContext var1);

    public static class WeightedAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float weight = 1.0f;
        @Editable
        public ActionConfig action = new CallFunction();
    }

    public static class Random
    extends ActionConfig {
        @Editable
        public WeightedAction[] actions = new WeightedAction[0];

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final float[] weights = new float[this.actions.length];
            final Executor[] executors = new Executor[this.actions.length];
            for (int ii = 0; ii < this.actions.length; ++ii) {
                WeightedAction waction = this.actions[ii];
                weights[ii] = waction.weight;
                executors[ii] = waction.action.createExecutor(ctx, scope);
            }
            return new DisposalExcutor(){
                Executor executor = null;

                @Override
                public void execute() {
                    this.executor = executors[RandomUtil.getWeightedIndex((float[])weights)];
                    this.executor.execute();
                }

                @Override
                public boolean isCompleted() {
                    if (this.executor == null) {
                        return true;
                    }
                    return this.executor.isCompleted();
                }

                @Override
                public void dispose() {
                    if (executors != null) {
                        for (Executor e : executors) {
                            e.dispose();
                        }
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            for (WeightedAction waction : this.actions) {
                waction.action.preload(ctx);
            }
        }
    }

    public static class Compound
    extends ActionConfig {
        @Editable
        public ActionConfig[] actions = new ActionConfig[0];

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            if (this.actions.length == 1) {
                return this.actions[0].createExecutor(ctx, scope);
            }
            final Executor[] executors = new Executor[this.actions.length];
            for (int ii = 0; ii < this.actions.length; ++ii) {
                executors[ii] = this.actions[ii].createExecutor(ctx, scope);
            }
            return new DisposalExcutor(){

                @Override
                public void execute() {
                    for (Executor executor : executors) {
                        executor.execute();
                    }
                }

                @Override
                public boolean isCompleted() {
                    for (Executor executor : executors) {
                        if (executor.isCompleted()) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void dispose() {
                    for (Executor executor : executors) {
                        executor.dispose();
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            for (ActionConfig action : this.actions) {
                action.preload(ctx);
            }
        }
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable
        public BooleanExpression condition = new BooleanExpression.Constant(true);
        @Editable
        public ActionConfig action = new CallFunction();
    }

    public static class Conditional
    extends ActionConfig {
        @Editable
        public Case[] cases = new Case[0];
        @Editable
        public ActionConfig defaultAction = new CallFunction();

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final BooleanExpression.Evaluator[] evaluators = new BooleanExpression.Evaluator[this.cases.length];
            final Executor[] executors = new Executor[this.cases.length];
            for (int ii = 0; ii < this.cases.length; ++ii) {
                Case caze = this.cases[ii];
                evaluators[ii] = caze.condition.createEvaluator(scope);
                executors[ii] = caze.action.createExecutor(ctx, scope);
            }
            final Executor defaultExecutor = this.defaultAction.createExecutor(ctx, scope);
            return new DisposalExcutor(){
                Executor executor;
                {
                    this.executor = defaultExecutor;
                }

                @Override
                public void execute() {
                    for (int ii = 0; ii < cases.length; ++ii) {
                        if (!evaluators[ii].evaluate()) continue;
                        this.executor = executors[ii];
                        this.executor.execute();
                        return;
                    }
                    defaultExecutor.execute();
                }

                @Override
                public boolean isCompleted() {
                    return this.executor.isCompleted();
                }

                @Override
                public void dispose() {
                    for (int ii = 0; ii < executors.length; ++ii) {
                        executors[ii].dispose();
                    }
                    if (defaultExecutor != null) {
                        defaultExecutor.dispose();
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            this.defaultAction.preload(ctx);
            for (Case c : this.cases) {
                c.action.preload(ctx);
            }
        }
    }

    public static class ShakeCamera
    extends ActionConfig {
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float frequency = 50.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float falloff = 30.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float duration = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float innerRadius = 10.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float outerRadius = 100.0f;
        @Editable(step=0.01)
        public Vector3f amplitude = new Vector3f(Vector3f.UNIT_Z);

        @Override
        public Executor createExecutor(final GlContext ctx, Scope scope) {
            final Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            return new DisposalExcutor(){
                protected Vector3f _translation = new Vector3f();

                @Override
                public void execute() {
                    transform.extractTranslation(this._translation);
                    CameraHandler camhand = ctx.getCameraHandler();
                    float dist = camhand.getViewerTranslation().distance(this._translation);
                    if (dist <= outerRadius) {
                        float scale = dist <= innerRadius ? 1.0f : 1.0f - (dist - innerRadius) / (outerRadius - innerRadius);
                        camhand.addOffset(this.createOffset(scale));
                    }
                }
            };
        }

        protected CameraHandler.Offset createOffset(final float scale) {
            return new CameraHandler.Offset(){
                protected long _start = System.currentTimeMillis();

                @Override
                public boolean apply(Transform3D transform) {
                    float elapsed = (float)(System.currentTimeMillis() - this._start) / 1000.0f;
                    transform.getTranslation().addScaledLocal(amplitude, scale * FloatMath.exp(-falloff * elapsed) * FloatMath.sin(frequency * elapsed));
                    return elapsed < duration;
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
        }
    }

    public static class PlaySound
    extends ActionConfig {
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
        @Editable
        public String node = "";
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();
        @Editable(hgroup="u")
        public boolean stopWithAnimation;

        @Override
        public Executor createExecutor(final GlContext ctx, final Scope scope) {
            Articulated.Node node = (Articulated.Node)ScopeUtil.call(scope, "getNode", this.node);
            final Transform3D parent = node == null ? ScopeUtil.resolve(scope, "worldTransform", new Transform3D()) : node.getWorldTransform();
            final Transform3D world = new Transform3D();
            return new DisposalExcutor(){

                @Override
                public void execute() {
                    Sounder sounder = new Sounder((AlContext)GlContextWrapper.getBase(ctx), scope, world, sounder);
                    parent.compose(transform, world);
                    sounder.start();
                    if (!sounder.loops()) {
                        ScopeUtil.call(sounder.getParentScope(), "addDisposal", sounder);
                    }
                    if (stopWithAnimation) {
                        Animation _lastAnimation = null;
                        for (Scope parent2 = scope; parent2 != null; parent2 = parent2.getParentScope()) {
                            if (!(parent2 instanceof Animation)) continue;
                            _lastAnimation = (Animation)parent2;
                        }
                        if (_lastAnimation != null) {
                            final Sounder innerSounder = sounder;
                            _lastAnimation.addObserver(new AnimationObserver(){

                                @Override
                                public boolean animationStopped(Animation animation, boolean completed) {
                                    innerSounder.stop();
                                    innerSounder.dispose();
                                    return !completed;
                                }

                                @Override
                                public boolean animationStarted(Animation animation) {
                                    return true;
                                }
                            });
                        }
                    }
                }

                public String toString() {
                    if (sounder != null) {
                        return sounder.toString();
                    }
                    return super.toString();
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Config(SounderConfig.class, this.sounder).preload(ctx);
        }
    }

    public static class SpawnTransient
    extends ActionConfig {
        @Editable(hgroup="u")
        public boolean moveWithOrigin;
        @Editable(hgroup="u")
        public boolean modifyAnimSpeed;
        @Editable(hgroup="u")
        public boolean stopWithAnimation;
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable
        public String node = "";
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();

        @Override
        public Executor createExecutor(GlContext ctx, final Scope scope) {
            final Function spawnTransient = ScopeUtil.resolve(scope, "spawnTransient", Function.NULL);
            Articulated.Node node = (Articulated.Node)ScopeUtil.call(scope, "getNode", this.node);
            final Transform3D parent = node == null ? ScopeUtil.resolve(scope, "worldTransform", new Transform3D()) : node.getWorldTransform();
            final Function getSpeedModifier = this.modifyAnimSpeed ? ScopeUtil.resolve(scope, "getSpeedModifier", Function.NULL) : null;
            return new DisposalExcutor(){
                protected Transform3D _world = new Transform3D();

                @Override
                public void execute() {
                    parent.compose(transform, this._world);
                    ArticulatedConfig.ensureRigidOrUniform(this._world);
                    final Scene.Transient spawned = (Scene.Transient)spawnTransient.call(model, this._world);
                    if ((moveWithOrigin || getSpeedModifier != null) && spawned != null) {
                        spawned.setUpdater(new Updater(){

                            @Override
                            public void update() {
                                if (moveWithOrigin) {
                                    parent.compose(transform, _world);
                                    ArticulatedConfig.ensureRigidOrUniform(_world);
                                    spawned.setLocalTransform(_world);
                                }
                                if (getSpeedModifier != null) {
                                    float mod = ((Float)getSpeedModifier.call(new Object[0])).floatValue();
                                    for (Animation anim : spawned.getPlayingAnimations()) {
                                        anim.setSpeedModifier(mod);
                                    }
                                }
                            }
                        });
                    }
                    if (spawned != null && stopWithAnimation) {
                        Scope parent2 = scope;
                        Animation _lastAnimation = null;
                        if (spawned.getConfig() == null) {
                            spawned.setConfig(model);
                        }
                        do {
                            if (!(parent2 instanceof Animation)) continue;
                            _lastAnimation = (Animation)parent2;
                        } while ((parent2 = parent2.getParentScope()) != null);
                        if (_lastAnimation != null) {
                            Animation topAnimation = _lastAnimation;
                            topAnimation.addObserver(new AnimationObserver(){

                                @Override
                                public boolean animationStopped(Animation animation, boolean completed) {
                                    ScopeUtil.call(scope, "remove", spawned, false);
                                    ScopeUtil.call(scope, "returnToTransientPool", spawned);
                                    return !completed;
                                }

                                @Override
                                public boolean animationStarted(Animation animation) {
                                    return true;
                                }
                            });
                        }
                    }
                }

                @Override
                public boolean isCompleted() {
                    return true;
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Model(this.model).preload(ctx);
        }
    }

    public static class CallFunction
    extends ActionConfig {
        @Editable
        public String name = "";
        @Editable
        public String arg = "";

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final Function fn = ScopeUtil.resolve(scope, this.name, Function.NULL);
            return new DisposalExcutor(){

                @Override
                public void execute() {
                    if (arg.isEmpty()) {
                        fn.call(new Object[0]);
                    } else {
                        fn.call(arg);
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
        }
    }
}

