/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.samskivert.util.ArrayUtil;
import com.threerings.export.Exportable;
import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Triangle;
import com.threerings.math.Vector3f;
import com.threerings.opengl.util.GlUtil;
import java.util.Comparator;

public class CollisionMesh
implements Exportable {
    protected Node _root;

    public CollisionMesh(Vector3f ... vertices) {
        Triangle[] triangles = new Triangle[vertices.length / 3];
        for (int ii = 0; ii < triangles.length; ++ii) {
            triangles[ii] = new Triangle(vertices[ii * 3], vertices[ii * 3 + 1], vertices[ii * 3 + 2]);
        }
        this._root = CollisionMesh.createNode(triangles);
    }

    public CollisionMesh() {
    }

    public Box getBounds() {
        return this._root.getBounds();
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        return this._root.getIntersection(ray, result);
    }

    protected static Node createNode(Triangle[] triangles) {
        Box bounds = new Box(Vector3f.MAX_VALUE, Vector3f.MIN_VALUE);
        for (Triangle triangle : triangles) {
            bounds.addLocal(triangle.getFirstVertex());
            bounds.addLocal(triangle.getSecondVertex());
            bounds.addLocal(triangle.getThirdVertex());
        }
        if (triangles.length == 1) {
            return new LeafNode(bounds, triangles[0]);
        }
        Vector3f bsize = bounds.getMaximumExtent().subtract(bounds.getMinimumExtent());
        float max = Math.max(bsize.x, Math.max(bsize.y, bsize.z));
        if (bsize.x == max) {
            GlUtil.divide(triangles, Triangle.X_COMPARATOR);
        } else if (bsize.y == max) {
            GlUtil.divide(triangles, Triangle.Y_COMPARATOR);
        } else {
            GlUtil.divide(triangles, Triangle.Z_COMPARATOR);
        }
        return new InternalNode(bounds, CollisionMesh.createNode((Triangle[])ArrayUtil.splice((Object[])triangles, (int)(triangles.length / 2))), CollisionMesh.createNode((Triangle[])ArrayUtil.splice((Object[])triangles, (int)0, (int)(triangles.length / 2))));
    }

    protected static class CenterComparator
    implements Comparator<Triangle> {
        protected int _idx;

        public CenterComparator(int idx) {
            this._idx = idx;
        }

        @Override
        public int compare(Triangle t1, Triangle t2) {
            return Float.compare(t1.getCenter().get(this._idx), t2.getCenter().get(this._idx));
        }
    }

    protected static class LeafNode
    extends Node {
        protected Triangle _triangle;

        public LeafNode(Box bounds, Triangle triangle) {
            super(bounds);
            this._triangle = triangle;
        }

        public LeafNode() {
        }

        @Override
        public boolean computeIntersection(Ray3D ray, Vector3f result) {
            return this._triangle.getIntersection(ray, result);
        }
    }

    protected static class InternalNode
    extends Node {
        protected Node _left;
        protected Node _right;

        public InternalNode(Box bounds, Node left, Node right) {
            super(bounds);
            this._left = left;
            this._right = right;
        }

        public InternalNode() {
        }

        @Override
        protected boolean computeIntersection(Ray3D ray, Vector3f result) {
            if (this._left.getIntersection(ray, result)) {
                Vector3f origin;
                Vector3f lresult = new Vector3f(result);
                if (this._right.getIntersection(ray, result) && lresult.distanceSquared(origin = ray.getOrigin()) < result.distanceSquared(origin)) {
                    result.set(lresult);
                }
                return true;
            }
            return this._right.getIntersection(ray, result);
        }
    }

    protected static abstract class Node
    implements Exportable {
        protected Box _bounds;

        public Node(Box bounds) {
            this._bounds = bounds;
        }

        public Node() {
        }

        public Box getBounds() {
            return this._bounds;
        }

        public boolean getIntersection(Ray3D ray, Vector3f result) {
            return this._bounds.intersects(ray) && this.computeIntersection(ray, result);
        }

        protected abstract boolean computeIntersection(Ray3D var1, Vector3f var2);
    }
}

