/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.expr.Bound;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.Updater;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Articulated
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected ArticulatedConfig _config;
    protected Node[] _nodes;
    protected HashMap<String, Node> _nodesByName = new HashMap(0);
    protected Surface[] _surfaces;
    protected Animation[] _animations = new Animation[0];
    protected HashMap<String, Animation> _animationsByName = new HashMap(0);
    protected Model[] _configAttachments;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound(value="getBoneMatrix")
    protected Function _parentGetBoneMatrix = Function.NULL;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform;
    @Scoped
    protected TransformState _transformState = new TransformState();
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    @Scoped
    protected Box _nbounds = new Box();
    protected SceneElement.TickPolicy _tickPolicy;
    protected ArrayList<Model> _userAttachments = new ArrayList(0);
    protected boolean _started;
    protected ArrayList<Animation> _playing = new ArrayList(0);
    protected Animation[] _playingArray = new Animation[0];
    protected int _update;
    protected boolean _completed;

    public Articulated(GlContext ctx, Scope parentScope, ArticulatedConfig config) {
        super(parentScope);
        this._viewTransform = this._transformState.getModelview();
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ArticulatedConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Scoped
    public Matrix4f getBoneMatrix(String name) {
        Node node = this._nodesByName.get(name);
        return node == null ? (Matrix4f)this._parentGetBoneMatrix.call(name) : node.getBoneMatrix();
    }

    @Scoped
    public Node getNode(String name) {
        return this._nodesByName.get(name);
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public List<Model> getChildren() {
        ArrayList m = Lists.newArrayList((Object[])this._configAttachments);
        m.addAll(this._userAttachments);
        return Collections.unmodifiableList(m);
    }

    @Override
    public Transform3D getPointWorldTransform(String point) {
        Node node = this._nodesByName.get(point);
        return node == null ? null : node.getWorldTransform();
    }

    @Override
    public void attach(String point, Model model, boolean replace) {
        Node node = this.getAttachmentNode(point);
        if (node == null) {
            return;
        }
        if (replace) {
            this.detachAll(node);
        }
        model.setParentScope(node);
        if (this._userAttachments.contains(model)) {
            return;
        }
        this._userAttachments.add(model);
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (scene != null) {
            model.wasAdded(scene);
        }
    }

    @Override
    public void detach(Model model) {
        Scene scene = ((Model)this._parentScope).getScene(this);
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            if (this._userAttachments.get(ii) != model) continue;
            if (scene != null) {
                model.willBeRemoved();
            }
            this._userAttachments.remove(ii);
            return;
        }
        Log.log.warning((Object)"Missing attachment to remove.", new Object[]{"model", model});
    }

    @Override
    public void detachAll(String point) {
        this.detachAll(this._nodesByName.get(point));
    }

    @Override
    public List<Animation> getPlayingAnimations() {
        return this._playing;
    }

    @Override
    public Animation getAnimation(String name) {
        return this._animationsByName.get(name);
    }

    @Override
    public Animation[] getAnimations() {
        return this._animations;
    }

    @Override
    public Animation createAnimation() {
        return new Animation(this._ctx, this);
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void reset() {
        for (Model model : this._configAttachments) {
            model.reset();
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._userAttachments.get(ii).reset();
        }
        this._started = false;
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public void drawBounds() {
        for (Node node : this._nodes) {
            if (!(node instanceof MeshNode)) continue;
            DebugBounds.draw(((MeshNode)node)._bounds, Color4f.RED);
        }
        DebugBounds.draw(this._bounds, Color4f.WHITE);
        for (Scope scope : this._configAttachments) {
            ((Model)scope).drawBounds();
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._userAttachments.get(ii).drawBounds();
        }
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(prefix + "Articulated: " + this._worldTransform + " " + this._bounds);
        String pprefix = prefix + "  ";
        for (Node node : this._nodes) {
            node.dumpInfo(pprefix);
        }
        for (Scope scope : this._configAttachments) {
            ((Model)scope).dumpInfo(pprefix);
        }
        for (Model model : this._userAttachments) {
            model.dumpInfo(pprefix);
        }
        for (Animation animation : this._playing) {
            animation.dumpInfo(prefix);
        }
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        for (Model model : this._configAttachments) {
            model.wasAdded(scene);
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._userAttachments.get(ii).wasAdded(scene);
        }
    }

    @Override
    public void willBeRemoved() {
        for (Model model : this._configAttachments) {
            if (model != null) {
                model.willBeRemoved();
                continue;
            }
            System.out.println("NULL");
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._userAttachments.get(ii).willBeRemoved();
        }
    }

    @Override
    public void tick(float elapsed) {
        int ii;
        if (this._completed) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._config.skin.bounds.transform(this._worldTransform, this._nbounds);
        if (!this._started) {
            for (int ii2 = 0; ii2 < this._animations.length; ++ii2) {
                if (!this._config.animationMappings[ii2].startAutomatically) continue;
                this._animations[ii2].start();
            }
            this._started = true;
        }
        boolean tracksCompleted = false;
        this._playingArray = this._playing.toArray(this._playingArray);
        int nn = this._playing.size();
        for (ii = 0; ii < nn; ++ii) {
            tracksCompleted |= this._playingArray[ii].tick(elapsed);
        }
        this.updateTransforms();
        if (tracksCompleted) {
            for (ii = this._playing.size() - 1; ii >= 0; --ii) {
                Animation animation = this._playing.get(ii);
                if (!animation.hasCompleted()) continue;
                this._playing.remove(ii);
            }
        }
        for (Node node : this._nodes) {
            node.update();
        }
        this._completed = this._config.completable && this._playing.isEmpty();
        for (Scope scope : this._configAttachments) {
            if (scope == null) continue;
            ((Model)scope).tick(elapsed);
            this._nbounds.addLocal(((Model)scope).getBounds());
            this._completed &= ((Model)scope).hasCompleted();
        }
        nn = this._userAttachments.size();
        for (int ii3 = 0; ii3 < nn; ++ii3) {
            Model model = this._userAttachments.get(ii3);
            model.tick(elapsed);
            this._nbounds.addLocal(model.getBounds());
            this._completed &= model.hasCompleted();
        }
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector3f closest = result;
        if (this.getSkinIntersection(ray, result)) {
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        for (Node node : this._nodes) {
            if (!node.getIntersection(ray, result)) continue;
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        for (Scope scope : this._configAttachments) {
            if (scope == null || !((Model)scope).getIntersection(ray, result)) continue;
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            if (!this._userAttachments.get(ii).getIntersection(ray, result)) continue;
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        return result != closest;
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        for (Node node : this._nodes) {
            node.composite();
        }
        for (SimpleScope simpleScope : this._surfaces) {
            ((Surface)simpleScope).composite();
        }
        for (Scope scope : this._configAttachments) {
            if (scope == null) continue;
            ((Model)scope).composite();
        }
        int nn = this._userAttachments.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._userAttachments.get(ii).composite();
        }
    }

    @Override
    public void dispose() {
        int ii;
        Scene scene = ((Model)this._parentScope).getScene(this);
        int nn = this._userAttachments.size();
        for (ii = 0; ii < nn; ++ii) {
            Model model = this._userAttachments.get(ii);
            if (scene != null) {
                model.willBeRemoved();
            }
            model.dispose();
        }
        if (this._surfaces != null) {
            for (Surface surface : this._surfaces) {
                surface.dispose();
            }
        }
        if (this._animations != null) {
            nn = this._animations.length;
            for (ii = 0; ii < nn; ++ii) {
                if (this._animations[ii] == null) continue;
                this._animations[ii].dispose();
            }
        }
        for (Model model : this._configAttachments) {
            if (scene != null) {
                model.willBeRemoved();
            }
            model.dispose();
        }
        if (this._nodes != null) {
            for (Node node : this._nodes) {
                if (node == null) continue;
                node.dispose();
            }
        }
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    protected void updateFromConfig() {
        Model[] model;
        void var8_28;
        void var8_26;
        String[] userAttachmentNodes = new String[this._userAttachments.size()];
        for (int ii3 = 0; ii3 < userAttachmentNodes.length; ++ii3) {
            userAttachmentNodes[ii3] = ((Node)this._userAttachments.get((int)ii3).getParentScope()).getConfig().name;
        }
        IdentityHashMap onodes = Maps.newIdentityHashMap();
        if (this._nodes != null) {
            for (Node node : this._nodes) {
                onodes.put(node.getConfig(), node);
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        ArrayList<Node> nnodes = new ArrayList<Node>(8);
        this._config.root.getArticulatedNodes(this._ctx, this, onodes, nnodes, this._worldTransform, this._viewTransform);
        this._nodes = nnodes.toArray(new Node[nnodes.size()]);
        for (Node node : onodes.values()) {
            node.dispose();
        }
        this._nodesByName.clear();
        for (Node node : this._nodes) {
            this._nodesByName.put(node.getConfig().name, node);
        }
        for (ArticulatedConfig.NodeTransform transform : this._config.nodeTransforms) {
            Node node = this._nodesByName.get(transform.node);
            if (node == null) continue;
            node.setUpdater(transform.createUpdater(this._ctx, node));
        }
        HashMap materialConfigs = Maps.newHashMapWithExpectedSize((int)this._config.materialMappings.length);
        for (Node node : this._nodes) {
            node.createSurfaces(this._ctx, this._config.materialMappings, materialConfigs);
        }
        if (this._surfaces != null) {
            for (SimpleScope simpleScope : this._surfaces) {
                ((Surface)simpleScope).dispose();
            }
        }
        this._surfaces = Articulated.createSurfaces(this._ctx, this, this._config.skin.visible, this._config.materialMappings, materialConfigs);
        Animation[] oanims = this._animations;
        this._animations = new Animation[this._config.animationMappings.length];
        for (int ii2 = 0; ii2 < this._animations.length; ++ii2) {
            Animation anim;
            this._animations[ii2] = anim = oanims == null || oanims.length <= ii2 ? new Animation(this._ctx, this) : oanims[ii2];
            ArticulatedConfig.AnimationMapping animationMapping = this._config.animationMappings[ii2];
            anim.setConfig(animationMapping.name, animationMapping.animation);
            if (!this._started || !animationMapping.startOnUpdated || anim.isPlaying()) continue;
            anim.start();
        }
        if (oanims != null) {
            for (int ii = this._animations.length; ii < oanims.length; ++ii) {
                oanims[ii].dispose();
            }
        }
        this._animationsByName.clear();
        Animation[] ii = this._animations;
        int anim = ii.length;
        boolean bl = false;
        while (var8_26 < anim) {
            Animation animation = ii[var8_26];
            this._animationsByName.put(animation.getName(), animation);
            ++var8_26;
        }
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] omodels = this._configAttachments;
        this._configAttachments = new Model[this._config.attachments.length];
        boolean bl2 = false;
        while (var8_28 < this._configAttachments.length) {
            boolean create = omodels == null || omodels.length <= var8_28;
            model = create ? new Model(this._ctx) : omodels[var8_28];
            this._configAttachments[var8_28] = model;
            ArticulatedConfig.Attachment attachment = this._config.attachments[var8_28];
            model.setParentScope(this.getAttachmentNode(attachment.node));
            model.setConfig(attachment.model);
            model.getLocalTransform().set(attachment.transform);
            if (create && scene != null) {
                model.wasAdded(scene);
            }
            ++var8_28;
        }
        if (omodels != null) {
            void var8_30;
            int n = this._configAttachments.length;
            while (var8_30 < omodels.length) {
                Model model2 = omodels[var8_30];
                if (scene != null) {
                    model2.willBeRemoved();
                }
                model2.dispose();
                ++var8_30;
            }
        }
        ArrayList<Model> arrayList = this._userAttachments;
        this._userAttachments = new ArrayList(userAttachmentNodes.length);
        for (int ii4 = 0; ii4 < userAttachmentNodes.length; ++ii4) {
            model = arrayList.get(ii4);
            Node node = this.getAttachmentNode(userAttachmentNodes[ii4]);
            if (node != null) {
                model.setParentScope(node);
                this._userAttachments.add((Model)model);
                continue;
            }
            if (scene == null) continue;
            model.willBeRemoved();
        }
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            npolicy = SceneElement.TickPolicy.WHEN_VISIBLE;
            for (Model model3 : this._configAttachments) {
                npolicy = Articulated.mergePolicy(npolicy, model3);
            }
            int nn = this._userAttachments.size();
            for (int ii5 = 0; ii5 < nn; ++ii5) {
                npolicy = Articulated.mergePolicy(npolicy, this._userAttachments.get(ii5));
            }
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        this.updateBounds();
    }

    protected void animationStarted(Animation animation, float overrideBlendOut) {
        int ii;
        this._playing.remove(animation);
        int priority = animation.getPriority();
        if (overrideBlendOut >= 0.0f) {
            ((Model)this._parentScope).stopAnimations(priority, overrideBlendOut);
        }
        int nn = this._playing.size();
        for (ii = 0; ii < nn && priority < this._playing.get(ii).getPriority(); ++ii) {
        }
        this._playing.add(ii, animation);
        ((Model)this._parentScope).animationStarted(animation);
    }

    protected void animationStopped(Animation animation, boolean completed) {
        if (!completed) {
            this._playing.remove(animation);
        }
        ((Model)this._parentScope).animationStopped(animation, completed);
    }

    protected Node getAttachmentNode(String name) {
        Node node = this._nodesByName.get(name);
        if (node == null) {
            Log.log.warning((Object)"Missing node for attachment.", new Object[]{"node", name});
        }
        return node;
    }

    protected void detachAll(Node node) {
        Scene scene = ((Model)this._parentScope).getScene(this);
        for (int ii = this._userAttachments.size() - 1; ii >= 0; --ii) {
            Model model = this._userAttachments.get(ii);
            if (model.getParentScope() != node) continue;
            if (scene != null) {
                model.willBeRemoved();
            }
            this._userAttachments.remove(ii);
        }
    }

    protected void updateTransforms() {
        int nn = this._playing.size();
        if (nn == 1) {
            this._playing.get(0).updateTransforms();
            return;
        }
        ++this._update;
        for (int ii = 0; ii < nn; ++ii) {
            this._playing.get(ii).blendTransforms(this._update);
        }
    }

    protected boolean getSkinIntersection(Ray3D ray, Vector3f result) {
        CollisionMesh collision = this._config.skin.collision;
        if (collision == null || !collision.getIntersection(ray.transform(this._worldTransform.invert()), result)) {
            return false;
        }
        this._worldTransform.transformPointLocal(result);
        return true;
    }

    protected static SceneElement.TickPolicy mergePolicy(SceneElement.TickPolicy policy, Model model) {
        SceneElement.TickPolicy mpolicy = model.getTickPolicy();
        return mpolicy.ordinal() > policy.ordinal() ? mpolicy : policy;
    }

    public static class MeshNode
    extends Node {
        @Bound(value="nbounds")
        protected Box _parentBounds;
        @Scoped
        protected Box _bounds = new Box();
        @Scoped
        protected TransformState _transformState = new TransformState(2);
        protected Surface _surface;

        public MeshNode(GlContext ctx, Scope parentScope, ArticulatedConfig.MeshNode config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            super(ctx, parentScope);
            this._viewTransform = this._transformState.getModelview();
            this.setConfig(config, parentWorldTransform, parentViewTransform);
        }

        @Override
        public void createSurfaces(GlContext ctx, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
            ModelConfig.VisibleMesh mesh;
            if (this._surface != null) {
                this._surface.dispose();
            }
            this._surface = (mesh = ((ArticulatedConfig.MeshNode)this._config).visible) == null ? null : Model.Implementation.createSurface(ctx, this, mesh, materialMappings, materialConfigs);
        }

        @Override
        public void update() {
            super.update();
            this._parentBounds.addLocal(this._config.getBounds().transform(this._worldTransform, this._bounds));
        }

        @Override
        public boolean getIntersection(Ray3D ray, Vector3f result) {
            CollisionMesh collision = ((ArticulatedConfig.MeshNode)this._config).collision;
            if (collision == null || !this._bounds.intersects(ray) || !collision.getIntersection(ray.transform(this._worldTransform.invert()), result)) {
                return false;
            }
            this._worldTransform.transformPointLocal(result);
            return true;
        }

        @Override
        public void dumpInfo(String prefix) {
            System.out.println(prefix + this._config.name + ": " + this._worldTransform + " " + this._bounds);
        }

        @Override
        public void composite() {
            super.composite();
            if (this._surface != null) {
                this._surface.composite();
            }
        }

        @Override
        public void enqueue() {
            super.enqueue();
            this._transformState.setDirty(true);
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this._surface != null) {
                this._surface.dispose();
            }
        }
    }

    public static class Node
    extends SimpleScope
    implements Enqueueable {
        public int lastUpdate;
        public float totalWeight;
        protected GlContext _ctx;
        protected ArticulatedConfig.Node _config;
        protected Transform3D _parentWorldTransform;
        protected Transform3D _parentViewTransform;
        protected Transform3D _localTransform;
        @Scoped
        protected Transform3D _worldTransform = new Transform3D();
        @Scoped
        protected Transform3D _viewTransform;
        protected Transform3D _boneTransform;
        protected Updater _updater;

        public Node(GlContext ctx, Scope parentScope, ArticulatedConfig.Node config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            this(ctx, parentScope);
            this._viewTransform = new Transform3D(2);
            this.setConfig(config, parentWorldTransform, parentViewTransform);
        }

        public void setConfig(ArticulatedConfig.Node config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            this._config = config;
            this._parentWorldTransform = parentWorldTransform;
            this._parentViewTransform = parentViewTransform;
            if (this._localTransform == null) {
                this._localTransform = new Transform3D(config.transform);
            }
            this._updater = null;
        }

        public ArticulatedConfig.Node getConfig() {
            return this._config;
        }

        public Transform3D getParentWorldTransform() {
            return this._parentWorldTransform;
        }

        public Transform3D getParentViewTransform() {
            return this._parentViewTransform;
        }

        public Transform3D getLocalTransform() {
            return this._localTransform;
        }

        public Transform3D getWorldTransform() {
            return this._worldTransform;
        }

        public Transform3D getViewTransform() {
            return this._viewTransform;
        }

        public Matrix4f getBoneMatrix() {
            if (this._boneTransform == null) {
                this._boneTransform = this._viewTransform.compose(this._config.invRefTransform);
                this._boneTransform.update(3);
            }
            return this._boneTransform.getMatrix();
        }

        public void setUpdater(Updater updater) {
            this._updater = updater;
        }

        public void createSurfaces(GlContext ctx, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
        }

        public void update() {
            if (this._updater instanceof ArticulatedConfig.WorldTransformUpdater) {
                this._updater.update();
            }
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }

        public boolean getIntersection(Ray3D ray, Vector3f result) {
            return false;
        }

        public void dumpInfo(String prefix) {
            System.out.println(prefix + this._config.name + ": " + this._worldTransform);
        }

        public void composite() {
            this._ctx.getCompositor().addEnqueueable(this);
        }

        @Override
        public void enqueue() {
            if (this._updater instanceof ArticulatedConfig.ViewTransformUpdater) {
                this._updater.update();
            }
            this._parentViewTransform.compose(this._localTransform, this._viewTransform);
            if (this._boneTransform != null) {
                this._viewTransform.compose(this._config.invRefTransform, this._boneTransform);
                this._boneTransform.update(3);
            }
        }

        @Override
        public String getScopeName() {
            return "node";
        }

        protected Node(GlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }
    }
}

