/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.renderer.config.AlphaStateConfig;
import com.threerings.opengl.renderer.config.ColorMaskStateConfig;
import com.threerings.opengl.renderer.config.ColorStateConfig;
import com.threerings.opengl.renderer.config.CullStateConfig;
import com.threerings.opengl.renderer.config.DepthStateConfig;
import com.threerings.opengl.renderer.config.FogStateConfig;
import com.threerings.opengl.renderer.config.LightStateConfig;
import com.threerings.opengl.renderer.config.LineStateConfig;
import com.threerings.opengl.renderer.config.MaterialStateConfig;
import com.threerings.opengl.renderer.config.PointStateConfig;
import com.threerings.opengl.renderer.config.PolygonStateConfig;
import com.threerings.opengl.renderer.config.ShaderStateConfig;
import com.threerings.opengl.renderer.config.StencilStateConfig;
import com.threerings.opengl.renderer.config.TextureStateConfig;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.FogState;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;
import java.util.List;

public class PassConfig
extends DeepObject
implements Exportable,
Preloadable.LoadableConfig {
    @Editable
    public AlphaStateConfig alphaState = new AlphaStateConfig();
    @Editable(nullable=true)
    public ColorStateConfig colorStateOverride;
    @Editable
    public ColorMaskStateConfig colorMaskState = new ColorMaskStateConfig();
    @Editable
    public CullStateConfig cullState = new CullStateConfig();
    @Editable
    public DepthStateConfig depthState = new DepthStateConfig();
    @Editable(nullable=true)
    public FogStateConfig fogStateOverride;
    @Editable(nullable=true)
    public LightStateConfig lightStateOverride;
    @Editable(nullable=true)
    public LineStateConfig lineState;
    @Editable(nullable=true)
    public MaterialStateConfig materialState = new MaterialStateConfig.OneSided();
    @Editable(nullable=true)
    public PointStateConfig pointState;
    @Editable
    public PolygonStateConfig polygonState = new PolygonStateConfig();
    @Editable
    public ShaderStateConfig shaderState = new ShaderStateConfig.Disabled();
    @Editable
    public StencilStateConfig stencilState = new StencilStateConfig();
    @Editable
    public TextureStateConfig textureState = new TextureStateConfig();
    @Editable
    public ExpressionBinding[] staticBindings = ExpressionBinding.EMPTY_ARRAY;
    @Editable
    public ExpressionBinding[] dynamicBindings = ExpressionBinding.EMPTY_ARRAY;
    @Editable
    public boolean ignoreVertexColors;

    @Override
    public void preload(GlContext ctx) {
        this.materialState.getState();
        for (ExpressionBinding binding : this.staticBindings) {
            binding.preload(ctx);
        }
        for (ExpressionBinding binding : this.dynamicBindings) {
            binding.preload(ctx);
        }
    }

    @Deprecated
    public void getUpdateReferences(ConfigReferenceSet refs) {
    }

    public boolean isSupported(GlContext ctx, boolean fallback) {
        return (this.materialState == null || this.materialState.isSupported(fallback)) && this.shaderState.isSupported(ctx, fallback) && this.textureState.isSupported(ctx, fallback);
    }

    public PassDescriptor createDescriptor(GlContext ctx) {
        PassDescriptor desc = new PassDescriptor();
        this.shaderState.populateDescriptor(ctx, desc);
        this.textureState.populateDescriptor(desc);
        desc.colors = this.ignoreVertexColors ? false : desc.colors | (!(this.lightStateOverride instanceof LightStateConfig.Enabled) || this.materialState == null || this.materialState.colorMaterialMode != MaterialStateConfig.ColorMaterialMode.DISABLED);
        desc.normals = desc.normals | !(this.lightStateOverride instanceof LightStateConfig.Disabled);
        return desc;
    }

    public RenderState[] createStates(GlContext ctx, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
        RenderState[] states = RenderState.createEmptySet();
        states[0] = this.alphaState.getState();
        states[2] = this.colorStateOverride == null ? (RenderState)ScopeUtil.resolve(scope, "colorState", ColorState.WHITE, ColorState.class) : this.colorStateOverride.getState();
        states[3] = this.colorMaskState.getState();
        states[4] = this.cullState.getState();
        states[5] = this.depthState.getState();
        states[6] = this.fogStateOverride == null ? (RenderState)ScopeUtil.resolve(scope, "fogState", FogState.DISABLED, FogState.class) : this.fogStateOverride.getState();
        states[7] = this.lightStateOverride == null ? (RenderState)ScopeUtil.resolve(scope, "lightState", LightState.DISABLED, LightState.class) : this.lightStateOverride.getState(ctx, scope, updaters);
        states[8] = this.lineState == null ? null : this.lineState.getState();
        states[9] = this.materialState == null ? null : this.materialState.getState();
        states[10] = this.pointState == null ? null : this.pointState.getState();
        states[11] = this.polygonState.getState();
        states[13] = this.stencilState.getState();
        states[14] = this.textureState.getState(ctx, scope, adders, updaters);
        states[12] = this.shaderState.getState(ctx, scope, states, updaters);
        return states;
    }

    public void invalidate() {
        if (this.materialState != null) {
            this.materialState.invalidate();
        }
        this.textureState.invalidate();
        for (ExpressionBinding binding : this.staticBindings) {
            binding.invalidate();
        }
        for (ExpressionBinding binding : this.dynamicBindings) {
            binding.invalidate();
        }
    }
}

