/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Matrix4f;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.material.Projection;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.material.config.PassConfig;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.util.GlContext;

public class Surface
extends SimpleScope
implements Compositable,
ConfigUpdateListener<MaterialConfig> {
    protected GlContext _ctx;
    protected GeometryConfig _geometryConfig;
    protected MaterialConfig _materialConfig;
    @Scoped
    protected Matrix4f[] _boneMatrices;
    protected Geometry _geometry;
    protected RenderQueue.Group _group;
    protected Compositable _compositable;
    protected static final TechniqueConfig BLANK_TECHNIQUE = new TechniqueConfig();

    public Surface(GlContext ctx, Scope parentScope, GeometryConfig geometryConfig, MaterialConfig materialConfig) {
        this(ctx, parentScope, geometryConfig, materialConfig, ctx.getCompositor().getGroup());
    }

    public Surface(GlContext ctx, Scope parentScope, GeometryConfig geometryConfig, MaterialConfig materialConfig, RenderQueue.Group group) {
        this(ctx, parentScope, geometryConfig, materialConfig, null, group);
    }

    public Surface(GlContext ctx, Scope parentScope, Geometry geometry, MaterialConfig materialConfig) {
        this(ctx, parentScope, geometry, materialConfig, ctx.getCompositor().getGroup());
    }

    public Surface(GlContext ctx, Scope parentScope, Geometry geometry, MaterialConfig materialConfig, RenderQueue.Group group) {
        this(ctx, parentScope, null, materialConfig, geometry, group);
    }

    public void setMaterialConfig(MaterialConfig config) {
        if (this._materialConfig != null) {
            this._materialConfig.removeListener(this);
        }
        if ((this._materialConfig = config) != null) {
            this._materialConfig.addListener(this);
        }
        this.updateFromConfigs();
    }

    public MaterialConfig getMaterialConfig() {
        return this._materialConfig;
    }

    @Override
    public void composite() {
        this._compositable.composite();
    }

    @Override
    public void configUpdated(ConfigEvent<MaterialConfig> event) {
        this.updateFromConfigs();
    }

    @Override
    public String getScopeName() {
        return "surface";
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._materialConfig != null) {
            this._materialConfig.removeListener(this);
        }
    }

    protected Surface(GlContext ctx, Scope parentScope, GeometryConfig geometryConfig, MaterialConfig materialConfig, Geometry geometry, RenderQueue.Group group) {
        super(parentScope);
        this._ctx = ctx;
        this._geometryConfig = geometryConfig;
        this._geometry = geometry;
        this._group = group;
        this.setMaterialConfig(materialConfig);
    }

    protected void updateFromConfigs() {
        Projection[] projections;
        TechniqueConfig technique;
        String scheme = ScopeUtil.resolve(this._parentScope, "renderScheme", (String)null);
        TechniqueConfig techniqueConfig = technique = this._materialConfig == null ? BLANK_TECHNIQUE : this._materialConfig.getTechnique(this._ctx, scheme);
        if (technique == null) {
            Log.log.warning((Object)"No technique available to render material.", new Object[]{"material", this._materialConfig.getReference(), "scheme", scheme});
            technique = BLANK_TECHNIQUE;
        }
        if (technique.receivesProjections && (projections = ScopeUtil.resolve(this._parentScope, "projections", null, Projection[].class)) != null && projections.length > 0) {
            technique = Projection.rewrite(technique, projections);
        }
        if (this._geometryConfig != null) {
            PassDescriptor[] passes = technique.getDescriptors(this._ctx);
            this._geometry = this._geometryConfig.createGeometry(this._ctx, this, technique.deformer, passes);
        }
        this._boneMatrices = this._geometry.getBoneMatrices();
        this._compositable = technique.createCompositable(this._ctx, this, this._geometry, this._group);
    }

    static {
        ((TechniqueConfig.NormalEnqueuer)Surface.BLANK_TECHNIQUE.enqueuer).passes = new PassConfig[]{new PassConfig()};
    }
}

