/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.util;

import com.samskivert.swing.Controller;
import com.samskivert.swing.ControllerProvider;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;

public class ControllerUtil {
    public static final ActionListener DISPATCHER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ControllerUtil.postAction(event);
        }
    };

    public static void postAction(Component source, String action) {
        ControllerUtil.postAction(source, action, null);
    }

    public static void postAction(Component source, String action, Object argument) {
        ControllerUtil.postAction(new ActionEvent(source, 0L, 0, action, argument));
    }

    public static void postAction(ActionEvent event) {
        Object source = event.getSource();
        if (!(source instanceof Component)) {
            Log.log.warning((Object)("Tried to dispatch action on non-component [event=" + event + "]."), new Object[0]);
            return;
        }
        String action = event.getAction();
        Object argument = event.getArgument();
        for (Component comp = (Component)source; comp != null; comp = comp.getParent()) {
            Controller ctrl;
            if (!(comp instanceof ControllerProvider) || !(ctrl = ((ControllerProvider)comp).getController()).handleAction(source, action, argument)) continue;
            return;
        }
        Log.log.warning((Object)("Unable to find controller to process action [event=" + event + "]."), new Object[0]);
    }
}

