/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

public class KeyMap {
    public static final int NO_MAPPING = -1;
    public static final int ANY_MODIFIER = -1;
    protected Mapping[] _mappings = new Mapping[64];
    protected static final int BUCKETS = 64;

    public void addMapping(int modifiers, int keyCode, int command) {
        int kidx = keyCode % 64;
        Mapping map = this._mappings[kidx];
        while (map != null) {
            if (map.matches(modifiers, keyCode)) {
                map.command = command;
                return;
            }
            map = map.next;
        }
        map = new Mapping(modifiers, keyCode, command);
        map.next = this._mappings[kidx];
        this._mappings[kidx] = map;
    }

    public int lookupMapping(int modifiers, int keyCode) {
        int kidx = keyCode % 64;
        int defaultCommand = -1;
        Mapping map = this._mappings[kidx];
        while (map != null) {
            if (map.matches(modifiers, keyCode)) {
                return map.command;
            }
            if (map.matches(-1, keyCode)) {
                defaultCommand = map.command;
            }
            map = map.next;
        }
        return defaultCommand;
    }

    protected static class Mapping {
        public int modifiers;
        public int keyCode;
        public int command;
        public Mapping next;

        public Mapping(int modifiers, int keyCode, int command) {
            this.modifiers = modifiers;
            this.keyCode = keyCode;
            this.command = command;
        }

        public boolean matches(int modifiers, int keyCode) {
            return modifiers == this.modifiers && keyCode == this.keyCode;
        }
    }
}

