/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

import com.threerings.opengl.gui.text.Document;

public class IntegerDocument
extends Document {
    protected boolean _positive;

    public IntegerDocument() {
        this(false);
    }

    public IntegerDocument(boolean positive) {
        this._positive = positive;
    }

    @Override
    public Object getValue() {
        try {
            return Integer.valueOf(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected boolean validateEdit(String oldText, String newText) {
        if (newText.length() == 0) {
            return true;
        }
        if (newText.startsWith("-") && this._positive) {
            return false;
        }
        if (newText.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(newText);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

