/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public class HTMLView
extends Component {
    protected boolean _imageLoadsSynchronously = false;
    protected StyleSheet _style;
    protected Rectangle _rsize;
    protected BridgeView _view;
    protected Image _rendered;
    protected boolean _antialias = true;
    protected HTMLEditorKit _kit = new HTMLEditorKit(){
        private static final long serialVersionUID = 1L;
        BasicHTMLViewFactory _basicHtmlFactory = new BasicHTMLViewFactory();

        @Override
        public ViewFactory getViewFactory() {
            if (HTMLView.this._imageLoadsSynchronously) {
                return this._basicHtmlFactory;
            }
            return super.getViewFactory();
        }
    };

    public HTMLView(GlContext ctx) {
        super(ctx);
    }

    public HTMLView(GlContext ctx, String stylesheet, String contents) {
        super(ctx);
        this.setStyleSheet(stylesheet);
        this.setContents(contents);
    }

    public void setImageLoadsSynchronously(boolean newValue) {
        this._imageLoadsSynchronously = newValue;
    }

    public void setAntialiased(boolean antialias) {
        if (this._antialias != antialias) {
            this._antialias = antialias;
            this.forceRelayout();
        }
    }

    public void setStyleSheet(String stylesheet) {
        StyleSheet ss = new StyleSheet();
        try {
            ss.loadRules(new StringReader(stylesheet), null);
            this.setStyleSheet(ss);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failed to parse stylesheet.", new Object[]{"sheet", stylesheet, t});
        }
    }

    public void setStyleSheet(StyleSheet stylesheet) {
        this._style = stylesheet;
        this.forceRelayout();
    }

    public StyleSheet getStyleSheet() {
        return this._style;
    }

    public HTMLEditorKit getEditorKit() {
        return this._kit;
    }

    public void setContents(String contents) {
        if (this._style == null) {
            this._style = new StyleSheet();
        }
        HTMLDocument document = new HTMLDocument(this._style);
        try {
            this._kit.read(new StringReader(contents), (Document)document, 0);
            this.setContents(document);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failed to parse HTML.", new Object[]{"contents", contents, t});
        }
    }

    public void setContents(HTMLDocument document) {
        this._view = new BridgeView(this._kit.getViewFactory().create(document.getDefaultRootElement()));
        this.forceRelayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layout() {
        super.layout();
        if (this._view == null) {
            return;
        }
        int vwidth = this.getWidth() - this.getInsets().getHorizontal();
        int vheight = this.getHeight() - this.getInsets().getVertical();
        if (this._rendered != null && this._rsize != null && this._rsize.width == vwidth && this._rsize.height == vheight) {
            return;
        }
        BufferedImage image = new BufferedImage(vwidth, vheight, 6);
        Graphics2D gfx = image.createGraphics();
        this._rsize = new Rectangle(0, 0, vwidth, vheight);
        try {
            gfx.setClip(this._rsize);
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this._view.paint(gfx, this._rsize);
        }
        finally {
            gfx.dispose();
        }
        this._rendered = new Image(image);
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        super.renderComponent(renderer);
        if (this._rendered != null) {
            Insets insets = this.getInsets();
            this._rendered.render(renderer, insets.left, insets.bottom, this._alpha);
        }
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        if (this._view != null) {
            this._view.setSize(whint > 0 ? (float)whint : 0.0f, hhint > 0 ? (float)hhint : 0.0f);
            int px = (int)Math.ceil(this._view.getPreferredSpan(0));
            int py = (int)Math.ceil(this._view.getPreferredSpan(1));
            return new Dimension(Math.max(1, px), Math.max(1, py));
        }
        return new Dimension(Math.max(1, whint), Math.max(1, hhint));
    }

    protected void forceRelayout() {
        this._rsize = null;
        this._rendered = null;
        this.invalidate();
    }

    static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            View view = super.create(elem);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }

    protected class BridgeView
    extends View {
        protected View _target;

        public BridgeView(View target) {
            super(null);
            this._target = target;
            this._target.setParent(this);
        }

        public View getTarget() {
            return this._target;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            return this._target.getPreferredSpan(axis);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this._target.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            HTMLView.this.forceRelayout();
        }

        @Override
        public float getAlignment(int axis) {
            return this._target.getAlignment(axis);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this._target.setSize(alloc.width, alloc.height);
            this._target.paint(g, allocation);
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Whatchu talkin' 'bout Willis?");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this._target;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this._target.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this._target.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this._target.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this._target.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this._target.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this._target.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this._target.getElement();
        }

        @Override
        public void setSize(float width, float height) {
            this._target.setSize(width, height);
        }

        @Override
        public Container getContainer() {
            return null;
        }

        @Override
        public ViewFactory getViewFactory() {
            return HTMLView.this._kit.getViewFactory();
        }
    }
}

