/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import java.util.Arrays;
import java.util.Map;

public class TableLayout
extends LayoutManager {
    public static final Alignment LEFT = new Alignment();
    public static final Alignment CENTER = new Alignment();
    public static final Alignment RIGHT = new Alignment();
    public static final Alignment TOP = new Alignment();
    public static final Alignment BOTTOM = new Alignment();
    public static final Alignment STRETCH = new Alignment();
    protected Alignment _halign = LEFT;
    protected Alignment _valign = TOP;
    protected boolean _centerChildren;
    protected boolean _equalRows;
    protected int _rowgap;
    protected int _colgap;
    protected boolean[] _fixedColumns;
    protected Map<Component, Dimension> _pscache = Maps.newIdentityHashMap();

    public TableLayout(int columns) {
        this(columns, 0, 0);
    }

    public TableLayout(int columns, int rowgap, int colgap) {
        columns = Math.max(1, columns);
        this._fixedColumns = new boolean[columns];
        this._rowgap = rowgap;
        this._colgap = colgap;
    }

    public TableLayout setHorizontalAlignment(Alignment align) {
        this._halign = align;
        return this;
    }

    public TableLayout setVerticalAlignment(Alignment align) {
        this._valign = align;
        return this;
    }

    public TableLayout setFixedColumn(int column, boolean fixed) {
        this._fixedColumns[column] = fixed;
        return this;
    }

    public TableLayout setEqualRows(boolean equalRows) {
        this._equalRows = equalRows;
        return this;
    }

    public TableLayout setCenterChildren(boolean centerChildren) {
        this._centerChildren = centerChildren;
        return this;
    }

    @Override
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        Metrics metrics = this.computeMetrics(target, true, whint);
        int cx = (metrics.columnWidths.length - 1) * this._colgap;
        int rx = (this.computeRows(target, true) - 1) * this._rowgap;
        return new Dimension(this.sum(metrics.columnWidths) + cx, this.sum(metrics.rowHeights) + rx);
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int availwid = target.getWidth() - insets.getHorizontal();
        Metrics metrics = this.computeMetrics(target, false, availwid);
        int totwidth = this.sum(metrics.columnWidths) + (metrics.columnWidths.length - 1) * this._colgap;
        int totheight = this.sum(metrics.rowHeights) + (this.computeRows(target, false) - 1) * this._rowgap;
        int sx = insets.left;
        if (this._halign == RIGHT) {
            sx += target.getWidth() - insets.getHorizontal() - totwidth;
        } else if (this._halign == CENTER) {
            sx += (target.getWidth() - insets.getHorizontal() - totwidth) / 2;
        }
        int y = insets.bottom + totheight;
        if (this._valign == CENTER) {
            y += (target.getHeight() - insets.getVertical() - totheight) / 2;
        } else if (this._valign == TOP) {
            y = target.getHeight() - insets.top;
        }
        int row = 0;
        int col = 0;
        int x = sx;
        for (Component child : this.visibleChildren(target)) {
            int width = Math.min(metrics.columnWidths[col], availwid);
            int height = metrics.rowHeights[row];
            int xoffs = 0;
            int yoffs = 0;
            int cw = width;
            int ch = height;
            if (this._centerChildren) {
                Dimension d = this._pscache.get(child);
                if (d.width < width) {
                    xoffs = (width - d.width) / 2;
                    cw = d.width;
                }
                if (d.height < height) {
                    yoffs = (height - d.height) / 2;
                    ch = d.height;
                }
            }
            child.setBounds(x + xoffs, y - height + yoffs, cw, ch);
            x += metrics.columnWidths[col] + this._colgap;
            if (++col != metrics.columnWidths.length) continue;
            y -= height + this._rowgap;
            ++row;
            col = 0;
            x = sx;
        }
    }

    protected Metrics computeMetrics(Container target, boolean preferred, int whint) {
        int naturalWidth;
        Metrics metrics = new Metrics();
        metrics.columnWidths = new int[this._fixedColumns.length];
        int rows = this.computeRows(target, preferred);
        if (metrics.rowHeights == null || metrics.rowHeights.length != rows) {
            metrics.rowHeights = new int[rows];
        } else {
            Arrays.fill(metrics.rowHeights, 0);
        }
        Arrays.fill(metrics.columnWidths, 0);
        int row = 0;
        int col = 0;
        int maxrh = 0;
        int count = 0;
        for (Component child : this.visibleChildren(target)) {
            Dimension psize;
            if (!child.isValid() || (psize = this._pscache.get(child)) == null) {
                psize = child.getPreferredSize(whint, -1);
                this._pscache.put(child, psize);
            }
            if (psize.height > metrics.rowHeights[row]) {
                metrics.rowHeights[row] = psize.height;
                if (maxrh < psize.height) {
                    maxrh = psize.height;
                }
            }
            if (psize.width > metrics.columnWidths[col]) {
                metrics.columnWidths[col] = psize.width;
            }
            if (++col == metrics.columnWidths.length) {
                col = 0;
                ++row;
            }
            ++count;
        }
        if (this._pscache.size() != count) {
            this._pscache.clear();
        }
        if (!preferred && this._halign == STRETCH && (naturalWidth = this.sum(metrics.columnWidths)) > 0) {
            int ii;
            int freewid = 0;
            for (int ii2 = 0; ii2 < this._fixedColumns.length; ++ii2) {
                if (this._fixedColumns[ii2]) continue;
                freewid += metrics.columnWidths[ii2];
            }
            int avail = target.getWidth() - target.getInsets().getHorizontal() - naturalWidth - this._colgap * (metrics.columnWidths.length - 1);
            int used = 0;
            for (ii = 0; ii < metrics.columnWidths.length; ++ii) {
                if (this._fixedColumns[ii]) continue;
                int adjust = metrics.columnWidths[ii] * avail / freewid;
                int n = ii;
                metrics.columnWidths[n] = metrics.columnWidths[n] + adjust;
                used += adjust;
            }
            if (metrics.columnWidths.length > 0) {
                for (ii = 0; ii < this._fixedColumns.length; ++ii) {
                    if (this._fixedColumns[ii]) continue;
                    int n = ii;
                    metrics.columnWidths[n] = metrics.columnWidths[n] + (avail - used);
                    break;
                }
            }
        }
        if (this._equalRows) {
            Arrays.fill(metrics.rowHeights, maxrh);
        }
        return metrics;
    }

    protected int computeRows(Container target, boolean preferred) {
        int ccount = Iterables.size(this.visibleChildren(target));
        int rows = ccount / this._fixedColumns.length;
        if (ccount % this._fixedColumns.length != 0) {
            ++rows;
        }
        return rows;
    }

    protected Iterable<Component> visibleChildren(Container target) {
        return Iterables.filter(target.getChildren(), (Predicate)new Predicate<Component>(){

            public boolean apply(Component c) {
                return c.isVisible();
            }
        });
    }

    protected int sum(int[] values) {
        int total = 0;
        for (int value : values) {
            total += value;
        }
        return total;
    }

    protected class Metrics {
        public int cachedHint = Integer.MIN_VALUE;
        public int[] columnWidths;
        public int[] rowHeights;

        protected Metrics() {
        }
    }

    public static class Alignment {
    }
}

