/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.event;

import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.event.InputEvent;
import com.threerings.opengl.gui.event.KeyListener;

public class KeyEvent
extends InputEvent {
    public static final int KEY_PRESSED = 0;
    public static final int KEY_RELEASED = 1;
    protected int _type;
    protected char _keyChar;
    protected int _keyCode;
    protected boolean _repeat;

    public KeyEvent(Object source, long when, int modifiers, int type, char keyChar, int keyCode, boolean repeat) {
        super(source, when, modifiers);
        this._type = type;
        this._keyChar = keyChar;
        this._keyCode = keyCode;
        this._repeat = repeat;
    }

    public int getType() {
        return this._type;
    }

    public char getKeyChar() {
        if (this._keyChar == '\u0000') {
            switch (this._keyCode) {
                case 79: {
                    return '1';
                }
                case 80: {
                    return '2';
                }
                case 81: {
                    return '3';
                }
                case 75: {
                    return '4';
                }
                case 76: {
                    return '5';
                }
                case 77: {
                    return '6';
                }
                case 71: {
                    return '7';
                }
                case 72: {
                    return '8';
                }
                case 73: {
                    return '9';
                }
                case 82: {
                    return '0';
                }
            }
            return this._keyChar;
        }
        return this._keyChar;
    }

    public int getKeyCode() {
        return this._keyCode;
    }

    public boolean isRepeat() {
        return this._repeat;
    }

    @Override
    public void dispatch(ComponentListener listener) {
        super.dispatch(listener);
        switch (this._type) {
            case 0: {
                if (!(listener instanceof KeyListener)) break;
                ((KeyListener)listener).keyPressed(this);
                break;
            }
            case 1: {
                if (!(listener instanceof KeyListener)) break;
                ((KeyListener)listener).keyReleased(this);
            }
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", type=").append(this._type);
        buf.append(", char=").append(this._keyChar);
        buf.append(", code=").append(this._keyCode);
        buf.append(", repeat=").append(this._repeat);
    }
}

