/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.config.BackgroundConfig;
import com.threerings.opengl.gui.config.BorderConfig;
import com.threerings.opengl.gui.config.CursorConfig;
import com.threerings.opengl.gui.config.DimensionConfig;
import com.threerings.opengl.gui.config.FontConfig;
import com.threerings.opengl.gui.config.IconConfig;
import com.threerings.opengl.gui.config.InsetsConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.HashSet;

public class StyleConfig
extends ParameterizedConfig {
    public static final Original NULL_ORIGINAL = new Original();
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(GlContext ctx) {
        return this.implementation.getOriginal(ctx);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        this.implementation.getUpdateResources(paths);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> style;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(StyleConfig.class, this.style);
        }

        @Override
        public Original getOriginal(GlContext ctx) {
            StyleConfig config = ctx.getConfigManager().getConfig(StyleConfig.class, this.style);
            return config == null ? null : config.getOriginal(ctx);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(mode="alpha", hgroup="c")
        public Color4f color = new Color4f();
        @Editable(editor="config", mode="cursor", nullable=true, hgroup="c")
        public String cursor;
        @Editable(editor="config", mode="font", nullable=true, hgroup="f")
        public String font;
        @Editable(hgroup="f")
        public FontConfig.Style fontStyle = FontConfig.Style.PLAIN;
        @Editable(min=1.0, hgroup="f")
        public int fontSize = 12;
        @Editable(hgroup="e")
        public TextEffect textEffect = TextEffect.NONE;
        @Editable(hgroup="e")
        public int effectSize = 1;
        @Editable(mode="alpha", hgroup="e")
        public Color4f effectColor = new Color4f();
        @Editable(hgroup="a")
        public TextAlignment textAlignment = TextAlignment.LEFT;
        @Editable(hgroup="a")
        public VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        @Editable(hgroup="a")
        public int lineSpacing = 0;
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String feedbackSound;
        @Editable
        public InsetsConfig padding = new InsetsConfig();
        @Editable(nullable=true)
        public BackgroundConfig background;
        @Editable(nullable=true)
        public IconConfig icon;
        @Editable(nullable=true)
        public BorderConfig border;
        @Editable(nullable=true)
        public DimensionConfig size;
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> tooltipStyle;
        @Editable(nullable=true)
        public BackgroundConfig selectionBackground;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            if (this.cursor != null) {
                refs.add(CursorConfig.class, this.cursor);
            }
            if (this.font != null) {
                refs.add(FontConfig.class, this.font);
            }
        }

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.feedbackSound != null) {
                paths.add(this.feedbackSound);
            }
            if (this.background != null) {
                this.background.getUpdateResources(paths);
            }
            if (this.icon != null) {
                this.icon.getUpdateResources(paths);
            }
            if (this.selectionBackground != null) {
                this.selectionBackground.getUpdateResources(paths);
            }
        }

        @Override
        public Original getOriginal(GlContext ctx) {
            return this;
        }

        @Override
        public void invalidate() {
            if (this.background != null) {
                this.background.invalidate();
            }
            if (this.icon != null) {
                this.icon.invalidate();
            }
            if (this.border != null) {
                this.border.invalidate();
            }
            if (this.selectionBackground != null) {
                this.selectionBackground.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract void getUpdateReferences(ConfigReferenceSet var1);

        public void getUpdateResources(HashSet<String> paths) {
        }

        public abstract Original getOriginal(GlContext var1);

        public void invalidate() {
        }
    }

    public static enum TextEffect {
        NONE(0),
        OUTLINE(1),
        SHADOW(2),
        PLAIN(3),
        GLOW(4);

        protected int _constant;

        public int getConstant() {
            return this._constant;
        }

        private TextEffect(int constant) {
            this._constant = constant;
        }
    }

    public static enum VerticalAlignment {
        TOP(0),
        CENTER(2),
        BOTTOM(1);

        protected int _constant;

        public int getConstant() {
            return this._constant;
        }

        private VerticalAlignment(int constant) {
            this._constant = constant;
        }
    }

    public static enum TextAlignment {
        LEFT(0),
        CENTER(2),
        RIGHT(1);

        protected int _constant;

        public int getConstant() {
            return this._constant;
        }

        private TextAlignment(int constant) {
            this._constant = constant;
        }
    }
}

