/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.UserInterface;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.util.DeepObject;
import java.util.ArrayList;
import java.util.Objects;

@EditorTypes(value={Action.class, Any.class})
public abstract class EventConfig
extends DeepObject
implements Exportable {
    public abstract UserInterface.Script addHandler(UserInterface var1, Runnable var2);

    public static class Any
    extends EventConfig {
        @Editable
        public EventConfig[] events = new EventConfig[0];

        @Override
        public UserInterface.Script addHandler(UserInterface iface, Runnable runnable) {
            final UserInterface.Script[] scripts = new UserInterface.Script[this.events.length];
            for (int ii = 0; ii < this.events.length; ++ii) {
                scripts[ii] = this.events[ii].addHandler(iface, runnable);
            }
            UserInterface userInterface = iface;
            Objects.requireNonNull(userInterface);
            return new UserInterface.Script(userInterface){

                @Override
                public void init() {
                    for (UserInterface.Script script : scripts) {
                        script.init();
                    }
                }

                @Override
                public void cleanup() {
                    for (UserInterface.Script script : scripts) {
                        script.cleanup();
                    }
                }
            };
        }
    }

    public static class Action
    extends Targeted {
        @Editable(hgroup="t")
        public String action = "";

        @Override
        protected ComponentListener createListener(final Runnable runnable) {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (StringUtil.isBlank((String)action) || action.equals(event.getAction())) {
                        runnable.run();
                    }
                }
            };
        }
    }

    public static abstract class Targeted
    extends EventConfig {
        @Editable(hgroup="t")
        public String target = "";

        @Override
        public UserInterface.Script addHandler(UserInterface iface, Runnable runnable) {
            final ComponentListener listener = this.createListener(runnable);
            final ArrayList comps = Lists.newArrayList(iface.getComponents(this.target));
            UserInterface userInterface = iface;
            Objects.requireNonNull(userInterface);
            return new UserInterface.Script(userInterface){

                @Override
                public void init() {
                    for (Component comp : comps) {
                        comp.addListener(listener);
                    }
                }

                @Override
                public void cleanup() {
                    for (Component comp : comps) {
                        comp.removeListener(listener);
                    }
                }
            };
        }

        protected abstract ComponentListener createListener(Runnable var1);
    }
}

