/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.border.Border;
import com.threerings.opengl.gui.border.EmptyBorder;
import com.threerings.opengl.gui.border.LineBorder;
import com.threerings.opengl.gui.border.UnderlineBorder;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;

@EditorTypes(value={Solid.class, Blank.class, Underline.class})
public abstract class BorderConfig
extends DeepObject
implements Exportable {
    @Editable(hgroup="t")
    public int thickness = 1;
    @DeepOmit
    protected transient SoftReference<Border> _border;

    public Border getBorder() {
        Border border;
        Border border2 = border = this._border == null ? null : this._border.get();
        if (border == null) {
            border = this.createBorder();
            this._border = new SoftReference<Border>(border);
        }
        return border;
    }

    public void invalidate() {
        this._border = null;
    }

    protected abstract Border createBorder();

    public static class Blank
    extends BorderConfig {
        @Override
        protected Border createBorder() {
            return new EmptyBorder(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }

    public static class Solid
    extends BorderConfig {
        @Editable(mode="alpha", hgroup="t")
        public Color4f color = new Color4f();

        @Override
        protected Border createBorder() {
            return new LineBorder(this.color, this.thickness);
        }
    }

    public static class Underline
    extends BorderConfig {
        @Editable(mode="alpha", hgroup="t")
        public Color4f color = new Color4f();

        @Override
        protected Border createBorder() {
            return new UnderlineBorder(this.color, this.thickness);
        }
    }
}

