/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.media.image.Colorization;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.background.BlankBackground;
import com.threerings.opengl.gui.background.ImageBackground;
import com.threerings.opengl.gui.background.TintedBackground;
import com.threerings.opengl.gui.config.IconConfig;
import com.threerings.opengl.gui.config.InsetsConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.config.ColorizationConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.util.HashSet;

@EditorTypes(value={Solid.class, Image.class, ColorizedImage.class, Blank.class})
public abstract class BackgroundConfig
extends DeepObject
implements Exportable {
    @DeepOmit
    protected transient SoftReference<Background> _background;

    public void getUpdateResources(HashSet<String> paths) {
    }

    public Background getBackground(GlContext ctx) {
        Background background;
        Background background2 = background = this._background == null ? null : this._background.get();
        if (background == null) {
            background = this.createBackground(ctx);
            this._background = new SoftReference<Background>(background);
        }
        return background;
    }

    public void invalidate() {
        this._background = null;
    }

    protected abstract Background createBackground(GlContext var1);

    public static class Blank
    extends BackgroundConfig {
        @Override
        protected Background createBackground(GlContext ctx) {
            return new BlankBackground();
        }
    }

    public static class ColorizedImage
    extends Image {
        @Editable
        public ColorizationConfig[] colorizations = new ColorizationConfig[0];

        @Override
        protected com.threerings.opengl.gui.Image getImage(GlContext ctx) {
            return IconConfig.getImage(ctx, this.file, this.colorizations);
        }
    }

    public static class Image
    extends BackgroundConfig {
        @Editable(editor="resource", nullable=true, hgroup="f")
        @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
        public String file;
        @Editable(hgroup="m")
        public Mode mode = Mode.SCALE_XY;
        @Editable(hgroup="m")
        public Anchor anchor = Anchor.LOWER_LEFT;
        @Editable(nullable=true)
        public InsetsConfig frame;

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.file != null) {
                paths.add(this.file);
            }
        }

        @Override
        protected Background createBackground(GlContext ctx) {
            return this.file == null ? new BlankBackground() : new ImageBackground(this.mode.getConstant(), this.getImage(ctx), this.frame != null && this.mode.isFrame() ? this.frame.createInsets() : null, this.anchor.getConstant());
        }

        protected com.threerings.opengl.gui.Image getImage(GlContext ctx) {
            return ctx.getImageCache().getImage(this.file, new Colorization[0]);
        }

        public static enum Anchor {
            LOWER_LEFT(0),
            LOWER_RIGHT(1),
            UPPER_LEFT(3),
            UPPER_RIGHT(2);

            protected int _constant;

            public int getConstant() {
                return this._constant;
            }

            private Anchor(int constant) {
                this._constant = constant;
            }
        }

        public static enum Mode {
            CENTER_XY(0),
            CENTER_X(1),
            CENTER_Y(2),
            SCALE_XY(3),
            SCALE_X(4),
            SCALE_Y(5),
            TILE_XY(6),
            TILE_X(7),
            TILE_Y(8),
            FRAME_XY(9, true),
            FRAME_X(10, true),
            FRAME_Y(11, true),
            ASPECT_INNER(12),
            ASPECT_OUTER(13);

            protected int _constant;
            protected boolean _frame;

            public int getConstant() {
                return this._constant;
            }

            public boolean isFrame() {
                return this._frame;
            }

            private Mode(int constant) {
                this(constant, false);
            }

            private Mode(int constant, boolean frame) {
                this._constant = constant;
                this._frame = frame;
            }
        }
    }

    public static class Solid
    extends BackgroundConfig {
        @Editable(mode="alpha")
        public Color4f color = new Color4f(Color4f.BLACK);

        @Override
        protected Background createBackground(GlContext ctx) {
            return new TintedBackground(this.color);
        }
    }
}

