/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.util.GlContext;

public class ToggleButton
extends Button {
    public static final int SELECTED = 4;
    public static final int HOVER_SELECTED = 5;
    public static final int DOWN_SELECTED = 6;
    public static final int DISABLED_SELECTED = 7;
    protected boolean _selected;
    protected static final int STATE_COUNT = 8;
    protected static final String[] STATE_PCLASSES = new String[]{"Selected", "HoverSelected", "DownSelected", "DisabledSelected"};

    public ToggleButton(GlContext ctx, String text) {
        super(ctx, text);
    }

    public ToggleButton(GlContext ctx, String text, String action) {
        super(ctx, text, action);
    }

    public ToggleButton(GlContext ctx, Icon icon, String action) {
        super(ctx, icon, action);
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            this._selected = selected;
            this.stateDidChange();
        }
    }

    @Override
    public int getState() {
        int state = super.getState();
        if (!this._selected) {
            return state;
        }
        if (state == 2) {
            return 7;
        }
        if (state == 1) {
            return 5;
        }
        if (this._armed) {
            return 6;
        }
        return 4;
    }

    @Override
    protected int getStateCount() {
        return 8;
    }

    @Override
    protected String getStatePseudoClass(int state) {
        if (state >= 4) {
            return STATE_PCLASSES[state - 4];
        }
        return super.getStatePseudoClass(state);
    }

    @Override
    protected int getFallbackState(int state) {
        return state == 5 || state == 6 || state == 7 ? 4 : 0;
    }

    @Override
    protected void fireAction(long when, int modifiers) {
        this._selected = !this._selected;
        super.fireAction(when, modifiers);
    }
}

