/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.LabelRenderer;
import com.threerings.opengl.gui.config.FontConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;

public abstract class TextComponent
extends Component {
    protected int[] _haligns = new int[this.getStateCount()];
    protected int[] _valigns = new int[this.getStateCount()];
    protected int[] _teffects = new int[this.getStateCount()];
    protected int[] _effsizes = new int[this.getStateCount()];
    protected int[] _lineSpacings = new int[this.getStateCount()];
    protected Color4f[] _effcols = new Color4f[this.getStateCount()];
    protected TextFactory[] _textfacts = new TextFactory[this.getStateCount()];

    public TextComponent(GlContext ctx) {
        super(ctx);
    }

    public abstract void setText(String var1);

    public abstract String getText();

    public Object getValue() {
        return this.getText();
    }

    public TextFactory getTextFactory() {
        TextFactory textfact = this._textfacts[this.getState()];
        return textfact != null ? textfact : this._textfacts[0];
    }

    public int getHorizontalAlignment() {
        if (this._haligns != null) {
            int halign = this._haligns[this.getState()];
            return halign != -1 ? halign : this._haligns[0];
        }
        return 0;
    }

    public int getVerticalAlignment() {
        if (this._valigns != null) {
            int valign = this._valigns[this.getState()];
            return valign != -1 ? valign : this._valigns[0];
        }
        return 2;
    }

    public int getTextEffect() {
        if (this._teffects != null) {
            int teffect = this._teffects[this.getState()];
            return teffect != -1 ? teffect : this._teffects[0];
        }
        return 0;
    }

    public int getEffectSize() {
        if (this._effsizes != null) {
            int effsize = this._effsizes[this.getState()];
            return effsize > 0 ? effsize : this._effsizes[0];
        }
        return 1;
    }

    public Color4f getEffectColor() {
        if (this._effcols != null) {
            Color4f effcol = this._effcols[this.getState()];
            return effcol != null ? effcol : this._effcols[0];
        }
        return Color4f.WHITE;
    }

    public int getLineSpacing() {
        if (this._lineSpacings != null) {
            return this._lineSpacings[this.getState()];
        }
        return 0;
    }

    @Override
    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        super.updateFromStyleConfig(state, config);
        this._haligns[state] = config.textAlignment.getConstant();
        this._valigns[state] = config.verticalAlignment.getConstant();
        this._teffects[state] = config.textEffect.getConstant();
        this._effsizes[state] = config.effectSize;
        this._lineSpacings[state] = config.lineSpacing;
        this._effcols[state] = config.effectColor;
        FontConfig fconfig = this._ctx.getConfigManager().getConfig(FontConfig.class, config.font);
        this._textfacts[state] = (fconfig == null ? FontConfig.NULL : fconfig).getTextFactory(this._ctx, config.fontStyle, config.fontSize);
    }

    protected TextFactory getTextFactory(LabelRenderer forLabel) {
        return this.getTextFactory();
    }

    protected LabelRenderer.Config getLabelRendererConfig(LabelRenderer forLabel, int twidth) {
        LabelRenderer.Config config = new LabelRenderer.Config();
        config.text = forLabel.getText();
        config.color = this.getColor();
        config.effect = this.getTextEffect();
        config.effectSize = this.getEffectSize();
        config.effectColor = this.getEffectColor();
        config.spacing = this.getLineSpacing();
        config.minwidth = config.maxwidth = twidth;
        return config;
    }
}

