/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.config.ConfigReference;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.SpinnerLogic;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.util.GlContext;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Spinner
extends Container
implements UIConstants {
    protected SpinnerLogic _logic;
    protected String _action;
    protected TextComponent _editor;
    protected Button _next;
    protected Button _prev;
    protected ChangeListener _modelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Spinner.this.valueChanged();
        }
    };

    public Spinner(GlContext ctx) {
        this(ctx, new SpinnerNumberModel());
    }

    public Spinner(GlContext ctx, SpinnerModel model) {
        super(ctx);
        this._editor = this.createEditor(model);
        this._next = new Button(ctx, "+", "next");
        this._next.setStyleConfig(this.getDefaultStyleConfig() + "Next");
        this._prev = new Button(ctx, "-", "prev");
        this._prev.setStyleConfig(this.getDefaultStyleConfig() + "Prev");
        this._logic = new SpinnerLogic(this._editor, this._next, this._prev, model);
        model.addChangeListener(this._modelListener);
        this.setLayoutManager(GroupLayout.makeHoriz(GroupLayout.STRETCH, GroupLayout.RIGHT, GroupLayout.EQUALIZE));
        this.add(this._editor);
        GroupLayout butLayout = GroupLayout.makeVert(GroupLayout.CENTER).setGap(0);
        Container butBox = new Container(ctx, butLayout);
        butBox.add(this._next);
        butBox.add(this._prev);
        this.add(butBox, GroupLayout.FIXED);
    }

    public void setModel(SpinnerModel newModel) {
        SpinnerModel oldModel = this._logic.getModel();
        this._logic.setModel(newModel);
        oldModel.removeChangeListener(this._modelListener);
        newModel.addChangeListener(this._modelListener);
        this.valueChanged();
    }

    public SpinnerModel getModel() {
        return this._logic.getModel();
    }

    public void setAction(String action) {
        this._action = action;
    }

    public String getAction() {
        return this._action;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._logic.setEnabled(enabled);
    }

    @Override
    public void setStyleConfig(String name) {
        super.setStyleConfig(name);
        this._editor.setStyleConfig(name + "Editor");
        this._next.setStyleConfig(name + "Next");
        this._prev.setStyleConfig(name + "Prev");
    }

    public void setEditorStyleConfig(ConfigReference<StyleConfig> ref) {
        this._editor.setStyleConfig(ref);
    }

    public void setNextStyleConfig(ConfigReference<StyleConfig> ref) {
        this._next.setStyleConfig(ref);
    }

    public void setPreviousStyleConfig(ConfigReference<StyleConfig> ref) {
        this._prev.setStyleConfig(ref);
    }

    protected TextComponent createEditor(SpinnerModel model) {
        return new Label(this._ctx, "");
    }

    protected void valueChanged() {
        if (this.isAdded()) {
            Root root = this.getWindow().getRoot();
            this.fireAction(root.getTickStamp(), root.getModifiers());
        }
    }

    protected void fireAction(long when, int modifiers) {
        this.emitEvent(new ActionEvent(this, when, modifiers, this._action, this._logic.getValue()));
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/Spinner";
    }
}

