/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.ScrollBar;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lwjgl.opengl.GL11;

public abstract class ScrollingList<V, C extends Component>
extends Container {
    protected MouseWheelListener _wheelListener;
    protected BoundedRangeModel _model;
    protected List<Entry<V, C>> _values = new ArrayList<Entry<V, C>>();
    protected Viewport _vport;
    protected ScrollBar _vbar;
    protected int _lastBottom;
    protected static final int EXTENT = 2;

    public ScrollingList(GlContext ctx) {
        this(ctx, (Collection<V>)null);
    }

    public ScrollingList(GlContext ctx, Collection<? extends V> values) {
        super(ctx, new BorderLayout(0, 0));
        if (values != null) {
            for (V value : values) {
                this._values.add(new Entry(value));
            }
        }
        this._lastBottom = 0;
        this._model = new BoundedRangeModel(0, 0, 1, 1);
        this._vport = new Viewport(ctx);
        this.add(this._vport, BorderLayout.CENTER);
        this._model.addChangeListener(this._vport);
        this._vbar = new ScrollBar(this._ctx, 1, this._model);
        this.add(this._vbar, BorderLayout.EAST);
    }

    public void addValue(V value, boolean snapToBottom) {
        this.addValue(this._values.size(), value, snapToBottom);
    }

    public void addValue(int index, V value) {
        this.addValue(index, value, false);
    }

    public void addValues(Collection<? extends V> values) {
        this.addValues(this._values.size(), values);
    }

    public void addValues(int index, Collection<? extends V> values) {
        for (V value : values) {
            this._values.add(index++, new Entry(value));
        }
        this._vport.invalidate();
    }

    public void removeValues() {
        this._values.clear();
        this._model.setValue(0);
        this._vport.removeAll();
        this._vport.invalidate();
    }

    public int getIndex(V value) {
        int nn = this._values.size();
        for (int ii = 0; ii < nn; ++ii) {
            if (this._values.get((int)ii).value != value) continue;
            return ii;
        }
        return -1;
    }

    public void removeValuesFromTop(int num) {
        this.removeValuesAt(0, num);
    }

    public void removeValuesAt(int index, int num) {
        num = Math.min(index + num, this._values.size());
        for (int ii = index; ii < num; ++ii) {
            Entry<V, C> value = this._values.remove(index);
            this._vport.remove((Component)value.component);
        }
        this._vport.invalidate();
    }

    public void snapToValue(V value) {
        this._vport.invalidateAndSnapTo(value);
    }

    protected abstract C createComponent(V var1);

    protected void computeHeight(Entry<V, C> entry, Container container) {
        if (entry.height < 0) {
            if (entry.component == null) {
                entry.component = this.createComponent(entry.value);
            }
            boolean remove = false;
            if (!((Component)entry.component).isAdded()) {
                container.add((Component)entry.component);
                remove = true;
            }
            int twidth = container.getWidth() - container.getInsets().getHorizontal();
            entry.height = ((Component)entry.component).getPreferredSize((int)twidth, (int)0).height;
            if (remove) {
                container.remove((Component)entry.component);
            }
        }
    }

    protected void addValue(int index, V value, boolean snap) {
        this._values.add(index, new Entry(value));
        if (snap) {
            this._vport.invalidateAndSnap();
        } else {
            this._vport.invalidate();
        }
    }

    protected static class Entry<V, C extends Component> {
        public C component;
        public V value;
        public int height = -1;

        public Entry(V value) {
            this.value = value;
        }
    }

    protected class Viewport
    extends Container
    implements ChangeListener {
        protected int _offset;
        protected boolean _snap;
        protected V _snapValue;
        protected Rectangle _srect;

        public Viewport(GlContext ctx) {
            super(ctx, GroupLayout.makeVert(GroupLayout.NONE, GroupLayout.TOP, GroupLayout.STRETCH));
            this._srect = new Rectangle();
        }

        public void setGap(int gap) {
            ((GroupLayout)this.getLayoutManager()).setGap(gap);
        }

        public ScrollBar getVerticalScrollBar() {
            return ScrollingList.this._vbar;
        }

        public void invalidateAndSnap() {
            this._snap = ScrollingList.this._model.getValue() + ScrollingList.this._model.getExtent() >= ScrollingList.this._model.getMaximum();
            this.invalidate();
        }

        public void invalidateAndSnapTo(V value) {
            this._snapValue = value;
            this.invalidate();
        }

        @Override
        protected void wasAdded() {
            super.wasAdded();
            ScrollingList.this._wheelListener = ScrollingList.this._model.createWheelListener();
            this.addListener(ScrollingList.this._wheelListener);
        }

        @Override
        protected void wasRemoved() {
            super.wasRemoved();
            if (ScrollingList.this._wheelListener != null) {
                this.removeListener(ScrollingList.this._wheelListener);
                ScrollingList.this._wheelListener = null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.invalidate();
        }

        @Override
        public void invalidate() {
            Root root;
            Window window;
            if (!this._valid || (window = this.getWindow()) == null || (root = window.getRoot()) == null) {
                return;
            }
            this._valid = false;
            root.rootInvalidated(this);
        }

        @Override
        public void layout() {
            Entry entry;
            int theight = this.getHeight() - this.getInsets().getVertical();
            int gap = ((GroupLayout)this.getLayoutManager()).getGap();
            int totheight = 0;
            int snapheight = 0;
            int nn = ScrollingList.this._values.size();
            for (int ii = 0; ii < nn; ++ii) {
                Entry entry2 = ScrollingList.this._values.get(ii);
                ScrollingList.this.computeHeight(entry2, this);
                if (entry2.value == this._snapValue) {
                    snapheight = totheight + gap * ii;
                }
                totheight += entry2.height;
            }
            if (ScrollingList.this._values.size() > 1) {
                totheight += gap * ScrollingList.this._values.size() - 1;
            }
            int extent = Math.min(theight, totheight);
            int value = ScrollingList.this._model.getValue();
            if (this._snap) {
                value = totheight - extent;
                this._snap = false;
            } else if (this._snapValue != null) {
                this._snapValue = null;
                value = Math.min(totheight - extent, snapheight);
                ScrollingList.this._model.setValue(value);
            }
            if (extent != ScrollingList.this._model.getExtent() || totheight != ScrollingList.this._model.getMaximum()) {
                value = Math.min(value, totheight - extent);
                ScrollingList.this._model.setRange(0, value, extent, totheight);
            }
            this._offset = ScrollingList.this._model.getValue();
            int compIx = 0;
            for (int ii = 0; ii < ScrollingList.this._values.size(); ++ii) {
                entry = ScrollingList.this._values.get(ii);
                if (this._offset < entry.height) {
                    compIx = ii;
                    break;
                }
                this._offset -= entry.height + gap;
                if (entry.component == null) continue;
                if (((Component)entry.component).isAdded()) {
                    this.remove((Component)entry.component);
                }
                entry.component = null;
            }
            extent += this._offset;
            int topIx = compIx;
            while (compIx < ScrollingList.this._values.size() && extent > 0) {
                entry = ScrollingList.this._values.get(compIx);
                if (entry.component == null) {
                    entry.component = ScrollingList.this.createComponent(entry.value);
                }
                if (!((Component)entry.component).isAdded()) {
                    this.add(compIx - topIx, (Component)entry.component);
                }
                extent -= entry.height + gap;
                ++compIx;
            }
            while (compIx < ScrollingList.this._values.size()) {
                entry = ScrollingList.this._values.get(compIx);
                if (entry.component != null) {
                    if (((Component)entry.component).isAdded()) {
                        this.remove((Component)entry.component);
                    }
                    entry.component = null;
                }
                ++compIx;
            }
            super.layout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void renderComponent(Renderer renderer) {
            Insets insets = this.getInsets();
            GL11.glTranslatef((float)0.0f, (float)this._offset, (float)0.0f);
            Rectangle oscissor = Viewport.intersectScissor(renderer, this._srect, this.getAbsoluteX() + insets.left, this.getAbsoluteY() + insets.bottom - this._offset, this._width - insets.getHorizontal(), this._height - insets.getVertical());
            try {
                int ll = this.getComponentCount();
                for (int ii = 0; ii < ll; ++ii) {
                    this.getComponent(ii).render(renderer);
                }
            }
            finally {
                renderer.setScissor(oscissor);
                GL11.glTranslatef((float)0.0f, (float)(-this._offset), (float)0.0f);
            }
        }

        @Override
        public int getAbsoluteY() {
            return super.getAbsoluteY() + this._offset;
        }

        @Override
        public Component getHitComponent(int mx, int my) {
            Insets insets = this.getInsets();
            if (mx < this._x + insets.left || my < this._y + insets.bottom || mx >= this._x + this._width - insets.right || my >= this._y + this._height - insets.top) {
                return null;
            }
            mx -= this._x;
            my -= this._y + this._offset;
            Component hit = null;
            int ll = this.getComponentCount();
            for (int ii = 0; ii < ll; ++ii) {
                Component child = this.getComponent(ii);
                hit = child.getHitComponent(mx, my);
                if (hit == null) continue;
                return hit;
            }
            return this;
        }
    }
}

