/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.config.ConfigReference;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.BoundedSnappingRangeModel;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.ScrollBar;
import com.threerings.opengl.gui.ScrollButton;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import org.lwjgl.opengl.GL11;

public class ScrollPane
extends Container {
    protected Viewport _vport;
    protected ScrollBar _vbar;
    protected ScrollBar _hbar;
    protected ScrollButton _vlbtn;
    protected ScrollButton _vmbtn;
    protected ScrollButton _hlbtn;
    protected ScrollButton _hmbtn;
    protected boolean _showAlways = true;
    protected boolean _layingOut;

    public ScrollPane(GlContext ctx) {
        super(ctx, new BorderLayout(0, 0));
    }

    public ScrollPane(GlContext ctx, Component child) {
        this(ctx, child, true, false);
    }

    public ScrollPane(GlContext ctx, Component child, boolean vert, boolean horiz) {
        this(ctx, child, vert, horiz, -1);
    }

    public ScrollPane(GlContext ctx, Component child, boolean vert, boolean horiz, int snap) {
        this(ctx, child, vert, horiz, snap, false);
    }

    public ScrollPane(GlContext ctx, Component child, boolean vert, boolean horiz, int snap, boolean buttons) {
        super(ctx, new BorderLayout(0, 0));
        this.init(child, vert, horiz, snap, buttons);
    }

    public void init(Component child, boolean vert, boolean horiz, int snap, boolean buttons) {
        this._vport = new Viewport(this._ctx, child, vert, horiz, snap);
        this.add(this._vport, BorderLayout.CENTER);
        this._showAlways = buttons;
        if (vert) {
            if (buttons) {
                this._vlbtn = new ScrollButton(this._ctx, true, 1, this._vport.getVModel());
                this.add(this._vlbtn, BorderLayout.NORTH);
                this._vmbtn = new ScrollButton(this._ctx, false, 1, this._vport.getVModel());
                this.add(this._vmbtn, BorderLayout.SOUTH);
            } else {
                this._vbar = new ScrollBar(this._ctx, 1, this._vport.getVModel());
                this.add(this._vbar, BorderLayout.EAST);
            }
        }
        if (horiz) {
            if (buttons) {
                this._hlbtn = new ScrollButton(this._ctx, true, 0, this._vport.getHModel());
                this.add(this._hlbtn, BorderLayout.WEST);
                this._hmbtn = new ScrollButton(this._ctx, false, 0, this._vport.getHModel());
                this.add(this._hmbtn, BorderLayout.EAST);
            } else {
                this._hbar = new ScrollBar(this._ctx, 0, this._vport.getHModel());
                this.add(this._hbar, BorderLayout.SOUTH);
            }
        }
    }

    public Component getChild() {
        return this._vport.getTarget();
    }

    public ScrollBar getVerticalScrollBar() {
        return this._vbar;
    }

    public ScrollBar getHorizontalScrollBar() {
        return this._hbar;
    }

    public void setShowScrollbarAlways(boolean showAlways) {
        if (this._showAlways != showAlways && this._vlbtn == null && this._hlbtn == null) {
            this._showAlways = showAlways;
            this.invalidate();
        }
    }

    public void setViewportStyleConfig(ConfigReference<StyleConfig> ref) {
        this._vport.setStyleConfig(ref);
    }

    @Override
    public void layout() {
        BoundedRangeModel vmodel;
        BoundedRangeModel hmodel;
        if (this._layingOut || this._vport.getTarget().isValid()) {
            super.layout();
            return;
        }
        this._layingOut = true;
        if (this._vbar != null) {
            this._vport.storeOldV();
            if (this._showAlways && this._vbar.getParent() == null) {
                this.add(this._vbar, BorderLayout.EAST);
            } else if (!this._showAlways && this._vbar.getParent() != null) {
                this.remove(this._vbar);
            }
        }
        if (this._vlbtn != null) {
            this._vport.storeOldV();
            if (this._vlbtn.getParent() == null) {
                this.add(this._vlbtn, BorderLayout.NORTH);
                this.add(this._vmbtn, BorderLayout.SOUTH);
            }
        }
        if (this._hbar != null) {
            this._vport.storeOldH();
            if (this._showAlways && this._hbar.getParent() == null) {
                this.add(this._hbar, BorderLayout.SOUTH);
            } else if (!this._showAlways && this._hbar.getParent() != null) {
                this.remove(this._hbar);
            }
        }
        if (this._hlbtn != null) {
            this._vport.storeOldH();
            if (this._hlbtn.getParent() == null) {
                this.add(this._hlbtn, BorderLayout.WEST);
                this.add(this._hmbtn, BorderLayout.EAST);
            }
        }
        this.validate();
        if (this._showAlways) {
            this._layingOut = false;
            return;
        }
        boolean hadded = false;
        boolean vadded = false;
        if (this._hbar != null && (hmodel = this._hbar.getModel()).getExtent() != hmodel.getRange()) {
            this.add(this._hbar, BorderLayout.SOUTH);
            this.validate();
            hadded = true;
        }
        if (this._vbar != null && (vmodel = this._vbar.getModel()).getExtent() != vmodel.getRange()) {
            this.add(this._vbar, BorderLayout.EAST);
            this.validate();
            vadded = true;
        }
        if (vadded && !hadded && this._hbar != null && (hmodel = this._hbar.getModel()).getExtent() != hmodel.getRange()) {
            this.add(this._hbar, BorderLayout.SOUTH);
            this.validate();
        }
        this._layingOut = false;
    }

    protected static class Viewport
    extends Container {
        protected BoundedRangeModel _vmodel;
        protected BoundedRangeModel _hmodel;
        protected Component _target;
        protected MouseWheelListener _wheelListener;
        protected Rectangle _srect = new Rectangle();
        protected int _oldV;
        protected int _oldH;

        public Viewport(GlContext ctx, Component target, boolean vert, boolean horiz, int snap) {
            super(ctx);
            if (vert) {
                this._vmodel = snap > 0 ? new BoundedSnappingRangeModel(0, 0, 10, 10, snap) : new BoundedRangeModel(0, 0, 10, 10);
            }
            if (horiz) {
                this._hmodel = snap > 0 ? new BoundedSnappingRangeModel(0, 0, 10, 10, snap) : new BoundedRangeModel(0, 0, 10, 10);
            }
            this._target = target;
            this.add(this._target);
        }

        public Component getTarget() {
            return this._target;
        }

        public BoundedRangeModel getVModel() {
            return this._vmodel;
        }

        public BoundedRangeModel getHModel() {
            return this._hmodel;
        }

        public void storeOldV() {
            this._oldV = this._vmodel == null ? 0 : this._vmodel.getValue();
        }

        public void storeOldH() {
            this._oldH = this._hmodel == null ? 0 : this._hmodel.getValue();
        }

        @Override
        public void layout() {
            int value;
            int extent;
            Insets insets = this.getInsets();
            int twidth = this.getWidth() - insets.getHorizontal();
            int theight = this.getHeight() - insets.getVertical();
            Dimension d = this._target.getPreferredSize(twidth, theight);
            d.width = this._hmodel != null ? Math.max(d.width, twidth) : twidth;
            int n = d.height = this._vmodel != null ? Math.max(d.height, theight) : theight;
            if (this._target.getWidth() != d.width || this._target.getHeight() != d.height) {
                this._target.setBounds(insets.left, insets.bottom, d.width, d.height);
            }
            this._target.layout();
            if (this._vmodel != null) {
                extent = this.getHeight() - insets.getVertical();
                value = Math.max(0, Math.min(this._oldV, d.height - extent));
                this._vmodel.setRange(0, value, extent, d.height);
            }
            if (this._hmodel != null) {
                extent = this.getWidth() - insets.getHorizontal();
                value = Math.max(0, Math.min(this._oldH, d.width - extent));
                this._hmodel.setRange(0, value, extent, d.width);
            }
        }

        @Override
        public int getAbsoluteX() {
            return super.getAbsoluteX() + this.getXOffset();
        }

        @Override
        public int getAbsoluteY() {
            return super.getAbsoluteY() + this.getYOffset();
        }

        @Override
        public Component getHitComponent(int mx, int my) {
            Insets insets = this.getInsets();
            if (mx < this._x + insets.left || my < this._y + insets.bottom || mx >= this._x + this._width - insets.right || my >= this._y + this._height - insets.top) {
                return null;
            }
            mx -= this._x + this.getXOffset();
            my -= this._y + this.getYOffset();
            Component hit = null;
            int ll = this.getComponentCount();
            for (int ii = 0; ii < ll; ++ii) {
                Component child = this.getComponent(ii);
                hit = child.getHitComponent(mx, my);
                if (hit == null) continue;
                return hit;
            }
            return this;
        }

        @Override
        public void scrollRectToVisible(int x, int y, int w, int h) {
            int dx;
            int dy;
            Insets insets = this.getInsets();
            if (this._vmodel != null && (dy = this.positionAdjustment(this._vmodel.getExtent(), h, this._vmodel.getMaximum() - (y - insets.bottom) - h - this._vmodel.getValue())) != 0) {
                this._vmodel.setValue(this._vmodel.getValue() + dy);
            }
            if (this._hmodel != null && (dx = this.positionAdjustment(this._hmodel.getExtent(), w, x - insets.left - this._hmodel.getValue())) != 0) {
                this._hmodel.setValue(this._hmodel.getValue() + dx);
            }
        }

        protected int positionAdjustment(int parentExtent, int childExtent, int childPos) {
            if (childPos >= 0 && childExtent + childPos <= parentExtent) {
                return 0;
            }
            if (childPos <= 0 && childExtent + childPos >= parentExtent) {
                return 0;
            }
            if (childPos > 0 && childExtent <= parentExtent) {
                return childPos - parentExtent + childExtent;
            }
            if (childPos >= 0 && childExtent >= parentExtent) {
                return childPos;
            }
            if (childPos <= 0 && childExtent <= parentExtent) {
                return childPos;
            }
            if (childPos < 0 && childExtent >= parentExtent) {
                return childPos - parentExtent + childExtent;
            }
            return 0;
        }

        @Override
        protected void wasAdded() {
            super.wasAdded();
            if (this._vmodel != null) {
                this._wheelListener = this._vmodel.createWheelListener();
                this.addListener(this._wheelListener);
            } else if (this._hmodel != null) {
                this._wheelListener = this._hmodel.createWheelListener();
                this.addListener(this._wheelListener);
            }
        }

        @Override
        protected void wasRemoved() {
            super.wasRemoved();
            if (this._wheelListener != null) {
                this.removeListener(this._wheelListener);
                this._wheelListener = null;
            }
        }

        @Override
        protected String getDefaultStyleConfig() {
            return "Default/Viewport";
        }

        @Override
        protected Dimension computePreferredSize(int whint, int hhint) {
            Dimension dim = new Dimension(this._target.getPreferredSize(whint, hhint));
            if (hhint != -1 && dim.height > hhint) {
                dim.height = hhint;
            }
            if (whint != -1 && dim.width > whint) {
                dim.width = whint;
            }
            return dim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void renderComponent(Renderer renderer) {
            Insets insets = this.getInsets();
            int yoffset = this.getYOffset();
            int xoffset = this.getXOffset();
            GL11.glTranslatef((float)xoffset, (float)yoffset, (float)0.0f);
            Rectangle oscissor = Viewport.intersectScissor(renderer, this._srect, this.getAbsoluteX() + insets.left - xoffset, this.getAbsoluteY() + insets.bottom - yoffset, this._width - insets.getHorizontal(), this._height - insets.getVertical());
            try {
                this._target.render(renderer);
            }
            finally {
                renderer.setScissor(oscissor);
                GL11.glTranslatef((float)(-xoffset), (float)(-yoffset), (float)0.0f);
            }
        }

        protected final int getYOffset() {
            return this._vmodel == null ? 0 : this._vmodel.getValue() - (this._vmodel.getMaximum() - this._vmodel.getExtent());
        }

        protected final int getXOffset() {
            return this._hmodel == null ? 0 : -this._hmodel.getValue();
        }
    }
}

