/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.util.GlContext;

public class MoveableContainer
extends Container {
    private Window parent;
    float startX;
    float startY;
    float lastX;
    float lastY;

    public MoveableContainer(GlContext ctx) {
        super(ctx);
        MouseAdapter ls = new MouseAdapter(){
            float lastX;
            float lastY;

            @Override
            public void mousePressed(MouseEvent event) {
                this.lastX = event.getX();
                this.lastY = event.getY();
                if (MoveableContainer.this.parent != null) {
                    MoveableContainer.this._ctx.getApp().getRoot().moveToTop(MoveableContainer.this.parent);
                    MoveableContainer.this._ctx.getApp().getRoot().resortWindows();
                    MoveableContainer.this._ctx.getApp().getRoot().requestFocus(MoveableContainer.this.parent);
                }
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                int detaX = (int)(this.lastX - (float)event.getX());
                int detaY = (int)(this.lastY - (float)event.getY());
                this.lastX = event.getX();
                this.lastY = event.getY();
                if (MoveableContainer.this.parent != null) {
                    MoveableContainer.this.parent.setLocation(((MoveableContainer)MoveableContainer.this).parent._x - detaX, ((MoveableContainer)MoveableContainer.this).parent._y - detaY);
                }
            }
        };
        this.addListener(ls);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            this.parent = (Window)container;
            break;
        }
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        this.parent = null;
    }
}

