/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureUnit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Image {
    protected int _width;
    protected int _height;
    protected int _twidth;
    protected int _theight;
    protected BufferedImage _image;
    protected TextureUnit[] _units;
    protected static boolean _supportsNonPowerOfTwo = GLContext.getCapabilities().GL_ARB_texture_non_power_of_two;

    public static void configureTexture(Texture2D texture) {
        texture.setMinFilter(9729);
        int wrap = GLContext.getCapabilities().OpenGL12 ? 33071 : 10496;
        texture.setWrap(wrap, wrap);
    }

    public Image(URL image) throws IOException {
        this(ImageIO.read(image));
    }

    public Image(BufferedImage image) {
        this(image.getWidth(null), image.getHeight(null));
        this._image = image;
    }

    public Image(Texture2D texture) {
        this(texture, texture.getWidth(), texture.getHeight());
    }

    public Image(Texture2D texture, int width, int height) {
        this(width, height);
        this.setTexture(texture);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public Texture2D getTexture(Renderer renderer) {
        this.load(renderer, -1);
        return (Texture2D)this._units[0].texture;
    }

    public void render(Renderer renderer, int tx, int ty, float alpha) {
        this.render(renderer, tx, ty, this._width, this._height, alpha);
    }

    public void render(Renderer renderer, int tx, int ty, Color4f color, float alpha) {
        this.render(renderer, 0, 0, this._width, this._height, tx, ty, this._width, this._height, color, alpha);
    }

    public void render(Renderer renderer, int tx, int ty, int twidth, int theight, float alpha) {
        this.render(renderer, 0, 0, this._width, this._height, tx, ty, twidth, theight, alpha);
    }

    public void render(Renderer renderer, int sx, int sy, int swidth, int sheight, int tx, int ty, float alpha) {
        this.render(renderer, sx, sy, swidth, sheight, tx, ty, swidth, sheight, alpha);
    }

    public void render(Renderer renderer, int sx, int sy, int swidth, int sheight, int tx, int ty, int twidth, int theight, float alpha) {
        this.render(renderer, sx, sy, swidth, sheight, tx, ty, twidth, theight, Color4f.WHITE, alpha);
    }

    public void render(Renderer renderer, int sx, int sy, int swidth, int sheight, int tx, int ty, int twidth, int theight, Color4f color, float alpha) {
        if (alpha == 0.0f) {
            return;
        }
        this.load(renderer, -1);
        float lx = (float)sx / (float)this._twidth;
        float ly = (float)sy / (float)this._theight;
        float ux = (float)(sx + swidth) / (float)this._twidth;
        float uy = (float)(sy + sheight) / (float)this._theight;
        float a = color.a * alpha;
        renderer.setColorState(color.r * a, color.g * a, color.b * a, a);
        renderer.setTextureState(this._units);
        renderer.setMatrixMode(5888);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)lx, (float)ly);
        GL11.glVertex2f((float)tx, (float)ty);
        GL11.glTexCoord2f((float)ux, (float)ly);
        GL11.glVertex2f((float)(tx + twidth), (float)ty);
        GL11.glTexCoord2f((float)ux, (float)uy);
        GL11.glVertex2f((float)(tx + twidth), (float)(ty + theight));
        GL11.glTexCoord2f((float)lx, (float)uy);
        GL11.glVertex2f((float)tx, (float)(ty + theight));
        GL11.glEnd();
    }

    public void load(Renderer renderer, int format) {
        if (this._units != null) {
            return;
        }
        Texture2D texture = new Texture2D(renderer);
        if (format == -1) {
            texture.setImage(this._image, true, false, false, false);
        } else {
            texture.setImage(format, false, this._image, true, false, false);
        }
        Image.configureTexture(texture);
        this.setTexture(texture);
    }

    protected Image(int width, int height) {
        this._width = width;
        this._height = height;
    }

    protected void setTexture(Texture2D texture) {
        this._twidth = texture.getWidth();
        this._theight = texture.getHeight();
        this._units = new TextureUnit[]{new TextureUnit(texture)};
    }
}

