/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.TellFeedbackMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.ScrollBar;
import com.threerings.opengl.gui.TextArea;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;

public class ChatOverlay
extends Container
implements ChatDisplay {
    protected MessageBundle _msgs;
    protected Color4f[] _systemColors = new Color4f[3];
    protected Button _end;
    protected ScrollBar _scrollbar;
    protected TextArea _area;
    protected byte _chatOverlayTypeMode;
    protected Name _speaker;

    public ChatOverlay(GlContext ctx) {
        super(ctx, GroupLayout.makeHStretch());
        this.setBundle("global");
        String prefix = "Default_V2/Chat/ChatOverlay";
        String scrollBarPrefix = "Default_V2/ScrollBar/Chat/ScrollBar";
        this._area = new TextArea(this._ctx);
        this._area.setStyleConfig(prefix + "Text");
        final BoundedRangeModel model = this._area.getScrollModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ChatOverlay.this.updateButtons();
            }
        });
        Container sideCont = new Container(ctx, GroupLayout.makeVStretch());
        this.add(sideCont, GroupLayout.FIXED);
        this.add(this._area);
        this._scrollbar = new ScrollBar(ctx, 1, model, scrollBarPrefix);
        sideCont.add(this._scrollbar);
        this._end = new Button(this._ctx, "");
        this._end.setStyleConfig(prefix + "End");
        this._end.setEnabled(false);
        this._end.addListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setValue(model.getMaximum() - model.getExtent());
            }
        });
    }

    public ChatOverlay(GlContext ctx, byte chatOverlayTypeMode) {
        super(ctx, GroupLayout.makeHStretch());
        this.setBundle("global");
        String prefix = "Default_V2/Chat/ChatOverlay";
        String scrollBarPrefix = "Default_V2/ScrollBar/Chat/ScrollBar";
        this._area = new TextArea(this._ctx);
        this._area.setStyleConfig(prefix + "Text");
        final BoundedRangeModel model = this._area.getScrollModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ChatOverlay.this.updateButtons();
            }
        });
        Container sideCont = new Container(ctx, GroupLayout.makeVStretch());
        this.add(sideCont, GroupLayout.FIXED);
        this.add(this._area);
        this._scrollbar = new ScrollBar(ctx, 1, model, scrollBarPrefix);
        sideCont.add(this._scrollbar);
        this._end = new Button(this._ctx, "");
        this._end.setStyleConfig(prefix + "End");
        this._end.setEnabled(false);
        this._end.addListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setValue(model.getMaximum() - model.getExtent());
            }
        });
        this._chatOverlayTypeMode = chatOverlayTypeMode;
    }

    public void setBundle(String bundle) {
        this._msgs = this._ctx.getMessageManager().getBundle(bundle);
    }

    public void setPreferredWidth(int width) {
        this._area.setPreferredWidth(width);
    }

    public void setSystemColors(Color4f info, Color4f feedback, Color4f attention) {
        this._systemColors[0] = info;
        this._systemColors[1] = feedback;
        this._systemColors[2] = attention;
    }

    public void clear() {
        this._area.clearText();
    }

    public boolean displayMessage(ChatMessage msg, boolean alreadyDisplayed) {
        if (msg instanceof SystemMessage && this._chatOverlayTypeMode != 8 && this._chatOverlayTypeMode != 0) {
            return true;
        }
        if (msg instanceof UserMessage) {
            if ("teamChat".equals(msg.localtype) && this._chatOverlayTypeMode != 5 && this._chatOverlayTypeMode != 0) {
                return true;
            }
            if ("guildChat".equals(msg.localtype) && this._chatOverlayTypeMode != 6 && this._chatOverlayTypeMode != 0) {
                return true;
            }
            if (("userChat".equals(msg.localtype) || msg instanceof TellFeedbackMessage) && this._chatOverlayTypeMode != 7 && this._chatOverlayTypeMode != 0) {
                return true;
            }
            if (!("teamChat".equals(msg.localtype) || "guildChat".equals(msg.localtype) || "userChat".equals(msg.localtype) || msg instanceof TellFeedbackMessage || this._chatOverlayTypeMode == 0)) {
                return true;
            }
        }
        String format = msg.getFormat();
        String text = this.doFilterSensitive(msg);
        if (format != null && msg instanceof UserMessage) {
            UserMessage umsg = (UserMessage)msg;
            text = this._msgs.get(format, new Object[]{umsg.getSpeakerDisplayName(), text});
        } else if (format != null && msg instanceof SystemMessage) {
            text = this._msgs.get(format, new String[]{text});
        }
        BoundedRangeModel model = this._area.getScrollModel();
        boolean end = model.getValue() == model.getMaximum() - model.getExtent();
        this.appendMessage(msg, text + "\n", this.getColor(msg));
        if (end) {
            this._area.validate();
            model.setValue(model.getMaximum() - model.getExtent());
        }
        if (this._chatOverlayTypeMode == 7 && "userChat".equals(msg.localtype)) {
            UserMessage umsg = (UserMessage)msg;
            this._speaker = umsg.speaker;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
    }

    @Override
    public Component getHitComponent(int mx, int my) {
        Component comp = super.getHitComponent(mx, my);
        return (comp == this._end || this._scrollbar._children.contains(comp)) && comp.isEnabled() ? comp : null;
    }

    @Override
    public void validate() {
        BoundedRangeModel model = this._area.getScrollModel();
        boolean end = model.getValue() == model.getMaximum() - model.getExtent();
        super.validate();
        if (end) {
            model.setValue(model.getMaximum() - model.getExtent());
        }
    }

    public Name getSpeaker() {
        return this._speaker;
    }

    protected Color4f getColor(ChatMessage msg) {
        if (msg instanceof SystemMessage) {
            return this._systemColors[((SystemMessage)msg).attentionLevel];
        }
        if (msg instanceof TellFeedbackMessage) {
            return this._systemColors[1];
        }
        return null;
    }

    protected void appendMessage(ChatMessage msg, String text, Color4f color) {
        this._area.appendText(text, color);
    }

    protected String doFilterSensitive(ChatMessage msg) {
        return msg.message;
    }

    protected void updateButtons() {
        BoundedRangeModel model = this._area.getScrollModel();
        boolean notAtEnd = model.getValue() + model.getExtent() < model.getMaximum();
        boolean enabled = this.isEnabled();
        this._scrollbar.setEnabled(enabled);
        this._end.setEnabled(enabled && notAtEnd);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        this._area.invalidate();
    }
}

