/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.AbstractButton;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.config.CursorConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.util.GlContext;

public class Button
extends AbstractButton {
    public static final int DOWN = 3;
    protected String[] _feedbackSounds = new String[this.getStateCount()];
    protected static final int STATE_COUNT = 4;
    protected static final String[] STATE_PCLASSES = new String[]{"Down"};

    public Button(GlContext ctx, String text) {
        this(ctx, text, null, null, null);
    }

    public Button(GlContext ctx, String text, String action) {
        this(ctx, text, null, action, null);
    }

    public Button(GlContext ctx, String text, String action, Object argument) {
        this(ctx, text, null, action, argument);
    }

    public Button(GlContext ctx, String text, ActionListener listener, String action) {
        this(ctx, text, listener, action, null);
    }

    public Button(GlContext ctx, String text, ActionListener listener, String action, Object argument) {
        super(ctx, null, text, action, argument);
        if (listener != null) {
            this.addListener(listener);
        }
    }

    public Button(GlContext ctx, Icon icon, String action) {
        this(ctx, icon, (ActionListener)null, action, (Object)null);
    }

    public Button(GlContext ctx, Icon icon, String action, Object argument) {
        this(ctx, icon, (ActionListener)null, action, argument);
    }

    public Button(GlContext ctx, Icon icon, ActionListener listener, String action) {
        this(ctx, icon, listener, action, null);
    }

    public Button(GlContext ctx, Icon icon, ActionListener listener, String action, Object argument) {
        super(ctx, icon, null, action, argument);
        if (listener != null) {
            this.addListener(listener);
        }
    }

    public String getFeedbackSound() {
        String sound = this._feedbackSounds[this.getState()];
        return sound != null ? sound : this._feedbackSounds[0];
    }

    public void doClick() {
        if (this.isAdded()) {
            Root root = this.getWindow().getRoot();
            this.fireAction(root.getTickStamp(), root.getModifiers());
        }
    }

    @Override
    public int getState() {
        int state = super.getState();
        return this._armed && state != 2 ? 3 : state;
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/Button";
    }

    @Override
    protected int getStateCount() {
        return 4;
    }

    @Override
    protected String getStatePseudoClass(int state) {
        if (state >= 3) {
            return STATE_PCLASSES[state - 3];
        }
        return super.getStatePseudoClass(state);
    }

    @Override
    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        CursorConfig handCursor;
        super.updateFromStyleConfig(state, config);
        if (state == 0 && config.icon != null) {
            this._label.setIcon(config.icon.getIcon(this._ctx));
        }
        this._feedbackSounds[state] = config.feedbackSound;
        if (state != 2 && this._cursor == null && (handCursor = this._ctx.getConfigManager().getConfig(CursorConfig.class, "Hand")) != null) {
            this._cursor = handCursor.getCursor(this._ctx);
        }
    }

    @Override
    protected void fireAction(long when, int modifiers) {
        this.playFeedbackSound();
        this.emitEvent(new ActionEvent(this, when, modifiers, this._action, this._argument));
    }

    protected void playFeedbackSound() {
        Window window;
        String sound = this.getFeedbackSound();
        if (sound != null && this.isAdded() && (window = this.getWindow()) != null) {
            window.getRoot().playSound(sound);
        }
    }
}

