/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.util.GlContext;

public abstract class AbstractButton
extends Label {
    protected String _action;
    protected Object _argument;
    protected boolean _pressed;
    protected boolean _armed;

    public AbstractButton(GlContext ctx, Icon icon, String text, String action, Object argument) {
        super(ctx, icon, text);
        this._action = action;
        this._argument = argument;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public String getAction() {
        return this._action;
    }

    public void setArgument(Object argument) {
        this._argument = argument;
    }

    public Object getArgument() {
        return this._argument;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        if (this.isEnabled() && event instanceof MouseEvent) {
            int ostate = this.getState();
            MouseEvent mev = (MouseEvent)event;
            switch (mev.getType()) {
                default: {
                    return super.dispatchEvent(event);
                }
                case 6: {
                    int mx = mev.getX();
                    int my = mev.getY();
                    int ax = this.getAbsoluteX();
                    int ay = this.getAbsoluteY();
                    this._armed = this._pressed && mx >= ax && my >= ay && mx < ax + this._width && my < ay + this._height;
                    break;
                }
                case 0: {
                    this._armed = mev.getButton() == 0;
                    this._pressed = this._armed;
                    break;
                }
                case 1: {
                    if (this._armed) {
                        this.fireAction(mev.getWhen(), mev.getModifiers());
                    }
                    this._armed = false;
                    this._pressed = false;
                }
            }
            int state = this.getState();
            if (state != ostate) {
                this.stateDidChange();
            }
            if (this._listeners != null) {
                int ll = this._listeners.size();
                for (int ii = 0; ii < ll; ++ii) {
                    event.dispatch((ComponentListener)this._listeners.get(ii));
                }
            }
            return true;
        }
        return super.dispatchEvent(event);
    }

    protected abstract void fireAction(long var1, int var3);
}

