/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.samskivert.util.Randoms;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.Placer;
import com.threerings.util.DeepObject;

@EditorTypes(value={Point.class, Line.class, Box.class, Ring.class, Shell.class, Frustum.class})
public abstract class PlacerConfig
extends DeepObject
implements Exportable {
    public abstract Placer createPlacer(BaseParticleSystem.Layer var1);

    protected static abstract class SimplePlacer
    implements Placer {
        protected BaseParticleSystem.Layer _layer;

        public SimplePlacer(BaseParticleSystem.Layer layer) {
            this._layer = layer;
        }

        @Override
        public void place(Particle particle) {
            this._layer.pointToLayer(this.place(particle.getPosition()), true);
        }

        protected abstract Vector3f place(Vector3f var1);
    }

    public static class Frustum
    extends PlacerConfig {
        @Editable(min=0.0, step=0.1)
        public float nearDistance = 10.0f;
        @Editable(min=0.0, step=0.1)
        public float farDistance = 20.0f;
        @Editable
        public boolean solid = true;

        @Override
        public Placer createPlacer(final BaseParticleSystem.Layer layer) {
            return new Placer(){

                @Override
                public void place(Particle particle) {
                    float exp = solid ? 3.0f : 2.0f;
                    float distance = FloatMath.pow(FloatMath.random(FloatMath.pow(nearDistance, exp), FloatMath.pow(farDistance, exp)), 1.0f / exp);
                    Camera camera = layer.getCamera();
                    float scale = distance / camera.getNear();
                    float left = camera.getLeft() * scale;
                    float right = camera.getRight() * scale;
                    float bottom = camera.getBottom() * scale;
                    float top = camera.getTop() * scale;
                    Vector3f position = particle.getPosition();
                    if (solid) {
                        position.set(FloatMath.random(left, right), FloatMath.random(bottom, top), -distance);
                    } else {
                        float width = right - left;
                        float height = top - bottom;
                        Randoms r = Randoms.threadLocal();
                        if (r.getFloat(width + height) < width) {
                            position.set(r.getInRange(left, right), r.getBoolean() ? top : bottom, -distance);
                        } else {
                            position.set(r.getBoolean() ? left : right, r.getInRange(top, bottom), -distance);
                        }
                    }
                    layer.pointToLayer(camera.getWorldTransform().transformPointLocal(position), false);
                }
            };
        }
    }

    public static class Shell
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float innerRadius;
        @Editable(min=0.0, step=0.01)
        public float outerRadius = 1.0f;

        @Override
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                @Override
                protected Vector3f place(Vector3f position) {
                    float radius = FloatMath.pow(FloatMath.random(innerRadius * innerRadius * innerRadius, outerRadius * outerRadius * outerRadius), 0.33333334f);
                    float sine = FloatMath.random(-1.0f, 1.0f);
                    float cose = FloatMath.sqrt(1.0f - sine * sine);
                    float angle = Randoms.threadLocal().getFloat((float)Math.PI * 2);
                    return position.set(radius * FloatMath.cos(angle) * cose, radius * FloatMath.sin(angle) * cose, radius * sine);
                }
            };
        }
    }

    public static class Ring
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float innerRadius = 0.0f;
        @Editable(min=0.0, step=0.01)
        public float outerRadius = 1.0f;

        @Override
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                @Override
                protected Vector3f place(Vector3f position) {
                    float radius = FloatMath.sqrt(FloatMath.random(innerRadius * innerRadius, outerRadius * outerRadius));
                    float angle = Randoms.threadLocal().getFloat((float)Math.PI * 2);
                    return position.set(radius * FloatMath.cos(angle), radius * FloatMath.sin(angle), 0.0f);
                }
            };
        }
    }

    public static class Box
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float width = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float length = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float height = 1.0f;
        @Editable
        public boolean solid = true;

        @Override
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                @Override
                protected Vector3f place(Vector3f position) {
                    if (solid) {
                        return position.set(FloatMath.random(-0.5f, 0.5f) * width, FloatMath.random(-0.5f, 0.5f) * length, FloatMath.random(-0.5f, 0.5f) * height);
                    }
                    float xy = width * length;
                    float xz = width * height;
                    float yz = length * height;
                    Randoms r = Randoms.threadLocal();
                    float rand = r.getFloat(xy + xz + yz);
                    if (rand < xy) {
                        return position.set(r.getInRange(-0.5f, 0.5f) * width, r.getInRange(-0.5f, 0.5f) * length, (r.getBoolean() ? -0.5f : 0.5f) * height);
                    }
                    if (rand < xy + xz) {
                        return position.set(r.getInRange(-0.5f, 0.5f) * width, (r.getBoolean() ? -0.5f : 0.5f) * length, r.getInRange(-0.5f, 0.5f) * height);
                    }
                    return position.set((r.getBoolean() ? -0.5f : 0.5f) * width, r.getInRange(-0.5f, 0.5f) * length, r.getInRange(-0.5f, 0.5f) * height);
                }
            };
        }
    }

    public static class Line
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float length = 1.0f;

        @Override
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                @Override
                protected Vector3f place(Vector3f position) {
                    return position.set(FloatMath.random(-0.5f, 0.5f) * length, 0.0f, 0.0f);
                }
            };
        }
    }

    public static class Point
    extends PlacerConfig {
        @Override
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                @Override
                protected Vector3f place(Vector3f position) {
                    return position.set(0.0f, 0.0f, 0.0f);
                }
            };
        }
    }
}

