/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.math.FloatMath;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import java.util.ArrayList;

public final class PositionHistory {
    protected float _time;
    protected float _length;
    protected Transform3D _transform;
    protected ArrayList<Entry> _entries = new ArrayList();
    protected ArrayList<Entry> _pool = new ArrayList();

    public void init(Vector3f initial, Transform3D transform) {
        this._pool.addAll(this._entries);
        this._entries.clear();
        this._transform = transform;
        this._time = 0.0f;
        this.addEntry(initial, 0.0f);
    }

    public void record(Vector3f position, float elapsed, float length) {
        if (elapsed <= 0.0f) {
            return;
        }
        this.addEntry(position, this._time += elapsed);
        this._length = length;
        float cutoff = this._time - this._length;
        while (this._entries.size() > 0 && this._entries.get((int)0).time <= cutoff) {
            this._pool.add(this._entries.remove(0));
        }
    }

    public Vector3f get(float t, Vector3f result) {
        int dist;
        float time = this._time - (1.0f - t) * this._length;
        Entry start = this._entries.get(0);
        if (time <= start.time) {
            return result.set(start.position);
        }
        int eidx = this._entries.size() - 1;
        Entry end = this._entries.get(eidx);
        if (time >= end.time) {
            return result.set(end.position);
        }
        int sidx = 0;
        while ((dist = eidx - sidx) != 1) {
            int midx = dist == 2 ? sidx + 1 : sidx + Math.min(Math.max(FloatMath.round((float)dist * (time - start.time) / (end.time - start.time)), 1), dist - 1);
            Entry middle = this._entries.get(midx);
            if (time <= middle.time) {
                eidx = midx;
                end = middle;
                continue;
            }
            sidx = midx;
            start = middle;
        }
        return start.position.lerp(end.position, (time - start.time) / (end.time - start.time), result);
    }

    protected void addEntry(Vector3f position, float time) {
        Entry entry;
        int size = this._pool.size();
        Entry entry2 = entry = size == 0 ? new Entry(position, time) : this._pool.remove(size - 1).set(position, time);
        if (this._transform != null) {
            this._transform.transformPointLocal(entry.position);
        }
        this._entries.add(entry);
    }

    protected static final class Entry {
        public Vector3f position = new Vector3f();
        public float time;

        public Entry(Vector3f position, float time) {
            this.set(position, time);
        }

        public Entry set(Vector3f position, float time) {
            this.position.set(position);
            this.time = time;
            return this;
        }
    }
}

