/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.effect.AlphaMode;
import com.threerings.opengl.effect.ColorFunction;
import com.threerings.opengl.effect.FloatFunction;
import com.threerings.opengl.effect.PositionHistory;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.probs.ColorFunctionVariable;
import com.threerings.probs.FloatFunctionVariable;

public final class Particle {
    public float depth;
    protected float _age;
    protected float _lifescale;
    protected Vector3f _position = new Vector3f();
    protected PositionHistory _history = new PositionHistory();
    protected Vector3f _velocity = new Vector3f();
    protected Quaternion _orientation = new Quaternion();
    protected Vector3f _angularVelocity = new Vector3f();
    protected AlphaMode _alphaMode = AlphaMode.TRANSLUCENT;
    protected ColorFunction _colorfunc;
    protected Color4f _color = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    protected FloatFunction _sizefunc;
    protected float _size;
    protected FloatFunction _lengthfunc;
    protected float _length;
    protected FloatFunction _framefunc;
    protected float _frame;

    public Vector3f getPosition() {
        return this._position;
    }

    public Vector3f getPosition(float t, Vector3f result) {
        return this._lengthfunc == null ? result.set(this._position) : this._history.get(t, result);
    }

    public float getSize(float t) {
        return this._sizefunc.getValue(Math.max(this._age - t * this._length * this._lifescale, 0.0f));
    }

    public Vector3f getVelocity() {
        return this._velocity;
    }

    public Quaternion getOrientation() {
        return this._orientation;
    }

    public Vector3f getAngularVelocity() {
        return this._angularVelocity;
    }

    public Color4f getColor() {
        return this._color;
    }

    public void setSize(float size) {
        this._size = size;
    }

    public float getSize() {
        return this._size;
    }

    public float getFrame() {
        return this._frame;
    }

    public void init(float lifespan, AlphaMode alphaMode, ColorFunctionVariable color, FloatFunctionVariable size, FloatFunctionVariable length, FloatFunctionVariable frame, Transform3D historyTransform) {
        this._age = 0.0f;
        this._lifescale = 1.0f / lifespan;
        this._history.init(this._position, historyTransform);
        this._alphaMode = alphaMode;
        this._colorfunc = color.getValue(this._colorfunc);
        this._alphaMode.apply(this._colorfunc.getValue(0.0f, this._color));
        this._sizefunc = size.getValue(this._sizefunc);
        this._size = this._sizefunc.getValue(0.0f);
        if (length == null) {
            this._lengthfunc = null;
            this._length = 0.0f;
        } else {
            this._lengthfunc = length.getValue(this._lengthfunc);
            this._length = this._lengthfunc.getValue(0.0f);
        }
        if (frame == null) {
            this._framefunc = null;
            this._frame = 0.0f;
        } else {
            this._framefunc = frame.getValue(this._framefunc);
            this._frame = this._framefunc.getValue(0.0f);
        }
    }

    public boolean tick(float elapsed) {
        float f;
        this._age += elapsed * this._lifescale;
        if (f >= 1.0f) {
            return false;
        }
        this._position.addScaledLocal(this._velocity, elapsed);
        this._orientation.integrateLocal(this._angularVelocity, elapsed);
        this._alphaMode.apply(this._colorfunc.getValue(this._age, this._color));
        this._size = this._sizefunc.getValue(this._age);
        if (this._lengthfunc != null) {
            this._length = this._lengthfunc.getValue(this._age);
            this._history.record(this._position, elapsed, this._length);
        }
        if (this._framefunc != null) {
            this._frame = this._framefunc.getValue(this._age);
        }
        return true;
    }
}

