/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.threerings.config.ManagedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.material.config.MaterialRewriter;
import com.threerings.util.DeepObject;

public class RenderSchemeConfig
extends ManagedConfig {
    public static final RenderSchemeConfig INVALID = new RenderSchemeConfig();
    @Editable
    public Implementation implementation = new Normal();

    public boolean isCompatibleWith(RenderSchemeConfig other) {
        return this.implementation.isCompatibleWith(other);
    }

    public MaterialRewriter getMaterialRewriter() {
        return this.implementation.getMaterialRewriter();
    }

    public static class Special
    extends Implementation {
        @Editable(nullable=true)
        public MaterialRewriter materialRewriter;

        @Override
        public boolean isCompatibleWith(RenderSchemeConfig other) {
            return false;
        }

        @Override
        public MaterialRewriter getMaterialRewriter() {
            return this.materialRewriter;
        }
    }

    public static class Normal
    extends Implementation {
        @Override
        public boolean isCompatibleWith(RenderSchemeConfig other) {
            return other == null || other.implementation instanceof Normal;
        }

        @Override
        public MaterialRewriter getMaterialRewriter() {
            return null;
        }
    }

    @EditorTypes(value={Normal.class, Special.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract boolean isCompatibleWith(RenderSchemeConfig var1);

        public abstract MaterialRewriter getMaterialRewriter();
    }
}

