/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.camera;

import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Frustum;
import com.threerings.math.Matrix4f;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.math.Vector4f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;

public class Camera {
    protected Rectangle _viewport = new Rectangle();
    protected float _left = -1.0f;
    protected float _right = 1.0f;
    protected float _bottom = -1.0f;
    protected float _top = 1.0f;
    protected float _near = 1.0f;
    protected float _far = -1.0f;
    protected Vector3f _nearFarNormal = new Vector3f(Vector3f.UNIT_Z);
    protected boolean _ortho = true;
    protected boolean _mirrored;
    protected Matrix4f _projection = new Matrix4f();
    protected Transform3D _worldTransform = new Transform3D(2);
    protected Transform3D _viewTransform = new Transform3D(2);
    protected Frustum _localVolume = new Frustum();
    protected Frustum _worldVolume = new Frustum();

    public Transform3D getWorldTransform() {
        return this._worldTransform;
    }

    public Transform3D getViewTransform() {
        return this._viewTransform;
    }

    public Frustum getLocalVolume() {
        return this._localVolume;
    }

    public Frustum getWorldVolume() {
        return this._worldVolume;
    }

    public Rectangle getViewport() {
        return this._viewport;
    }

    public void setPerspective(float fovy, float aspect, float near, float far) {
        float top = near * FloatMath.tan(fovy / 2.0f);
        float bottom = -top;
        float right = top * aspect;
        float left = -right;
        this.setFrustum(left, right, bottom, top, near, far);
    }

    public void setFrustum(float left, float right, float bottom, float top, float near, float far) {
        this.setProjection(left, right, bottom, top, near, far, Vector3f.UNIT_Z, false, false);
    }

    public void setOrtho(float left, float right, float bottom, float top, float near, float far) {
        this.setProjection(left, right, bottom, top, near, far, Vector3f.UNIT_Z, true, false);
    }

    public void setProjection(Camera ocamera) {
        this.setProjection(ocamera.getLeft(), ocamera.getRight(), ocamera.getBottom(), ocamera.getTop(), ocamera.getNear(), ocamera.getFar(), ocamera.getNearFarNormal(), ocamera.isOrtho(), ocamera.isMirrored());
    }

    public void setProjection(float left, float right, float bottom, float top, float near, float far, Vector3f nearFarNormal, boolean ortho, boolean mirrored) {
        this._left = left;
        this._right = right;
        this._bottom = bottom;
        this._top = top;
        this._near = near;
        this._far = far;
        this._ortho = ortho;
        this._mirrored = mirrored;
        this._localVolume.setToProjection(this._left, this._right, this._bottom, this._top, this._near, this._far, this._nearFarNormal.set(nearFarNormal), this._ortho, this._mirrored);
        if (ortho) {
            this._projection.setToOrtho(left, right, bottom, top, near, far, nearFarNormal);
        } else {
            this._projection.setToFrustum(left, right, bottom, top, near, far, nearFarNormal);
        }
    }

    public Matrix4f getProjection() {
        return this._projection;
    }

    public float getLeft() {
        return this._left;
    }

    public float getRight() {
        return this._right;
    }

    public float getBottom() {
        return this._bottom;
    }

    public float getTop() {
        return this._top;
    }

    public float getNear() {
        return this._near;
    }

    public float getFar() {
        return this._far;
    }

    public Vector3f getNearFarNormal() {
        return this._nearFarNormal;
    }

    public boolean isOrtho() {
        return this._ortho;
    }

    public boolean isMirrored() {
        return this._mirrored;
    }

    public void updateTransform() {
        this._worldTransform.invert(this._viewTransform);
        this._worldTransform.update(3);
        this._viewTransform.update(3);
        this._localVolume.transform(this._worldTransform, this._worldVolume);
    }

    public void apply(Renderer renderer) {
        renderer.setViewport(this._viewport);
        renderer.setProjection(this._left, this._right, this._bottom, this._top, this._near, this._far, this._nearFarNormal, this._ortho);
        renderer.setFrontFace(this._mirrored ? 2304 : 2305);
    }

    public Box transformLocal(Box box) {
        return this.transform(box, box);
    }

    public Box transform(Box box) {
        return this.transform(box, new Box());
    }

    public Box transform(Box box, Box result) {
        return box.transform(this._viewTransform, result).projectLocal(this._projection);
    }

    public Vector3f transformLocal(Vector3f point) {
        return this.transform(point, point);
    }

    public Vector3f transform(Vector3f point) {
        return this.transform(point, new Vector3f());
    }

    public Vector3f transform(Vector3f point, Vector3f result) {
        return this._projection.projectPointLocal(this._viewTransform.transformPoint(point, result));
    }

    public void getTexGenPlanes(Vector4f s, Vector4f t, Vector4f q) {
        float rwidth = 1.0f / (this._right - this._left);
        float rheight = 1.0f / (this._top - this._bottom);
        if (this._ortho) {
            s.set(rwidth, 0.0f, 0.0f, -this._left * rwidth);
            t.set(0.0f, rheight, 0.0f, -this._bottom * rheight);
            q.set(0.0f, 0.0f, 0.0f, 1.0f);
        } else {
            s.set(rwidth, 0.0f, -0.5f / this._near, -0.5f - this._left * rwidth);
            t.set(0.0f, rheight, -0.5f / this._near, -0.5f - this._bottom * rheight);
            q.set(0.0f, 0.0f, -1.0f / this._near, 0.0f);
        }
    }

    public void getCenterRay(Ray3D result) {
        this.getEyeRay((this._left + this._right) / 2.0f, (this._bottom + this._top) / 2.0f, result);
    }

    public void getPickRay(int x, int y, Ray3D result) {
        float tx = (float)(x - this._viewport.x) / (float)this._viewport.width;
        float ty = (float)(y - this._viewport.y) / (float)this._viewport.height;
        this.getEyeRay(FloatMath.lerp(this._left, this._right, tx), FloatMath.lerp(this._bottom, this._top, ty), result);
    }

    protected void getEyeRay(float ex, float ey, Ray3D result) {
        result.getOrigin().set(ex, ey, -this._near);
        if (this._ortho) {
            result.getDirection().set(0.0f, 0.0f, -1.0f);
        } else {
            result.getDirection().set(ex, ey, -this._near);
        }
        result.transformLocal(this._worldTransform);
    }
}

