/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.samskivert.util.RandomUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Bound;
import com.threerings.expr.Disposal;
import com.threerings.expr.MutableBoolean;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.openal.Listener;
import com.threerings.openal.Log;
import com.threerings.openal.Sound;
import com.threerings.openal.SoundClipManager;
import com.threerings.openal.SoundGroup;
import com.threerings.openal.Source;
import com.threerings.openal.StackedStream;
import com.threerings.openal.Stream;
import com.threerings.openal.config.SounderConfig;
import com.threerings.openal.util.AlContext;
import com.threerings.opengl.util.GlContextWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Sounder
extends SimpleScope
implements ConfigUpdateListener<SounderConfig>,
Disposal {
    protected AlContext _ctx;
    @Scoped
    protected Transform3D _transform;
    protected SounderConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    @Bound
    protected MutableLong _now;
    @Scoped
    protected MutableLong _epoch;
    @Scoped
    protected MutableBoolean _started;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null, null){

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean isPlaying() {
            return false;
        }
    };

    public Sounder(AlContext ctx, Scope parentScope, Transform3D transform) {
        this(ctx, parentScope, transform, (SounderConfig)null);
    }

    public Sounder(AlContext ctx, Scope parentScope, Transform3D transform, ConfigReference<SounderConfig> ref) {
        this(ctx, parentScope, transform, ctx.getConfigManager().getConfig(SounderConfig.class, ref));
    }

    public Sounder(AlContext ctx, Scope parentScope, Transform3D transform, SounderConfig config) {
        super(parentScope);
        long now = System.currentTimeMillis();
        this._now = new MutableLong(now);
        this._epoch = new MutableLong(now);
        this._started = new MutableBoolean();
        this._ctx = ctx instanceof GlContextWrapper ? GlContextWrapper.getBase((GlContextWrapper)ctx) : ctx;
        this._transform = transform;
        this.setConfig(config);
    }

    public void setConfig(ConfigReference<SounderConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(SounderConfig.class, ref));
    }

    public void setConfig(SounderConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public boolean loops() {
        return this._impl.loops();
    }

    public void start() {
        this.resetEpoch();
        this._started.value = true;
        this._impl.start();
    }

    public void stop() {
        this._started.value = false;
        this._impl.stop();
    }

    public boolean isPlaying() {
        return this._impl.isPlaying();
    }

    @Override
    public boolean isCompleted() {
        return !this.isPlaying();
    }

    public void update() {
        this._impl.update();
    }

    @Override
    public void configUpdated(ConfigEvent<SounderConfig> event) {
        this.updateFromConfig();
    }

    @Override
    public String getScopeName() {
        return "sounder";
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.resetEpoch();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getSounderImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            if (this._impl.isPlaying()) {
                this._impl.stop();
                nimpl.start();
            }
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    protected void resetEpoch() {
        this._epoch.value = this._now.value;
    }

    public static class Random
    extends Implementation {
        protected SounderConfig.Random _config;
        protected Sounder[] _sounders;
        protected float[] _weights;
        protected Sounder _sounder;

        public Random(AlContext ctx, Scope parentScope, SounderConfig.Random config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Random config) {
            int ii;
            this._config = config;
            boolean wasPlaying = this.isPlaying();
            Sounder[] osounders = this._sounders;
            this._sounders = new Sounder[config.sounders.length];
            this._weights = new float[this._sounders.length];
            for (ii = 0; ii < this._sounders.length; ++ii) {
                Sounder sounder;
                SounderConfig.WeightedSounder wsounder = config.sounders[ii];
                this._sounders[ii] = sounder = osounders == null || osounders.length <= ii ? new Sounder(this._ctx, (Scope)this, this._transform, wsounder.sounder) : osounders[ii];
                this._weights[ii] = wsounder.weight;
            }
            if (osounders != null) {
                for (ii = this._sounders.length; ii < osounders.length; ++ii) {
                    osounders[ii].dispose();
                }
            }
            if ((wasPlaying || this._started.value && this.loops()) && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.loops()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void start() {
            this._sounder = this._sounders[RandomUtil.getWeightedIndex((float[])this._weights)];
            this._sounder.start();
        }

        @Override
        public void stop() {
            if (this._sounder != null) {
                this._sounder.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            return this._sounder != null && this._sounder.isPlaying();
        }

        @Override
        public void update() {
            if (this._sounder != null) {
                this._sounder.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Sounder sounder : this._sounders) {
                sounder.dispose();
            }
        }
    }

    public static class Scripted
    extends Implementation {
        protected SounderConfig.Scripted _config;
        protected Sounder[] _sounders;
        protected float[] _times;
        protected float _time;
        protected int _sidx;
        protected long _last;
        protected boolean _completed;
        @Bound
        protected MutableLong _now;

        public Scripted(AlContext ctx, Scope parentScope, SounderConfig.Scripted config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Scripted config) {
            int ii;
            boolean wasPlaying = this._sounders != null && this.isPlaying();
            this._config = config;
            Sounder[] osounders = this._sounders;
            this._sounders = new Sounder[config.sounders.length];
            this._times = new float[this._sounders.length];
            for (ii = 0; ii < this._sounders.length; ++ii) {
                Sounder sounder;
                this._sounders[ii] = sounder = osounders == null || osounders.length <= ii ? new Sounder(this._ctx, this, this._transform) : osounders[ii];
                SounderConfig.TimedSounder tsounder = config.sounders[ii];
                sounder.setConfig(tsounder.sounder);
                this._times[ii] = tsounder.time;
            }
            if (osounders != null) {
                for (ii = this._sounders.length; ii < osounders.length; ++ii) {
                    osounders[ii].dispose();
                }
            }
            if ((wasPlaying || this._started.value && this.loops()) && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            return this._config.loopDuration > 0.0f;
        }

        @Override
        public void start() {
            this._time = 0.0f;
            this._sidx = 0;
            this._last = this._now.value;
            this._completed = false;
        }

        @Override
        public void stop() {
            for (Sounder sounder : this._sounders) {
                sounder.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.isPlaying()) continue;
                return true;
            }
            return this._started.value && !this._completed;
        }

        @Override
        public void update() {
            if (this._completed) {
                return;
            }
            float elapsed = (float)(this._now.value - this._last) / 1000.0f;
            this._last = this._now.value;
            this._time += elapsed;
            this.startSounders();
            if (this._config.loopDuration > 0.0f) {
                if (this._time >= this._config.loopDuration) {
                    this._time %= this._config.loopDuration;
                    this._sidx = 0;
                    this.startSounders();
                }
            } else if (this._sidx >= this._sounders.length) {
                this._completed = true;
            }
        }

        protected void startSounders() {
            while (this._sidx < this._sounders.length && this._times[this._sidx] < this._time) {
                this._sounders[this._sidx].start();
                ++this._sidx;
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Sounder sounder : this._sounders) {
                sounder.dispose();
            }
        }
    }

    public static class Sequential
    extends Implementation {
        protected SounderConfig.Sequential _config;
        protected Sounder[] _sounders;
        protected int _sidx;
        protected boolean _completed;

        public Sequential(AlContext ctx, Scope parentScope, SounderConfig.Sequential config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Sequential config) {
            int ii;
            boolean wasPlaying = this._sounders != null && this.isPlaying();
            this._config = config;
            Sounder[] osounders = this._sounders;
            this._sounders = new Sounder[config.sounders.length];
            for (ii = 0; ii < this._sounders.length; ++ii) {
                Sounder sounder;
                this._sounders[ii] = sounder = osounders == null || osounders.length <= ii ? new Sounder(this._ctx, this, this._transform) : osounders[ii];
                sounder.setConfig(config.sounders[ii].sounder);
            }
            if (osounders != null) {
                for (ii = this._sounders.length; ii < osounders.length; ++ii) {
                    osounders[ii].dispose();
                }
            }
            if ((wasPlaying || this._started.value && this.loops()) && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            if (this._config.loop) {
                return true;
            }
            for (Sounder sounder : this._sounders) {
                if (!sounder.loops()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void start() {
            this._sidx = 0;
            this._sounders[0].start();
            this._completed = false;
        }

        @Override
        public void stop() {
            for (Sounder sounder : this._sounders) {
                sounder.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.isPlaying()) continue;
                return true;
            }
            return this._started.value && !this._completed;
        }

        @Override
        public void update() {
            if (this._completed) {
                return;
            }
            this._sounders[this._sidx].update();
            if (this._sounders[this._sidx].isPlaying()) {
                return;
            }
            ++this._sidx;
            if (this._sidx >= this._sounders.length) {
                if (this._config.loop) {
                    this._sidx %= this._sounders.length;
                } else {
                    --this._sidx;
                    this._completed = true;
                    return;
                }
            }
            this._sounders[this._sidx].start();
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Sounder sounder : this._sounders) {
                sounder.dispose();
            }
        }
    }

    public static class Compound
    extends Implementation {
        protected Sounder[] _sounders;

        public Compound(AlContext ctx, Scope parentScope, SounderConfig.Compound config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Compound config) {
            int ii;
            boolean wasPlaying = this._sounders != null && this.isPlaying();
            Sounder[] osounders = this._sounders;
            this._sounders = new Sounder[config.sounders.length];
            for (ii = 0; ii < this._sounders.length; ++ii) {
                Sounder sounder;
                this._sounders[ii] = sounder = osounders == null || osounders.length <= ii ? new Sounder(this._ctx, this, this._transform) : osounders[ii];
                sounder.setConfig(config.sounders[ii].sounder);
            }
            if (osounders != null) {
                for (ii = this._sounders.length; ii < osounders.length; ++ii) {
                    osounders[ii].dispose();
                }
            }
            if ((wasPlaying || this._started.value && this.loops()) && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.loops()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void start() {
            for (Sounder sounder : this._sounders) {
                sounder.start();
            }
        }

        @Override
        public void stop() {
            for (Sounder sounder : this._sounders) {
                sounder.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.isPlaying()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void update() {
            for (Sounder sounder : this._sounders) {
                sounder.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Sounder sounder : this._sounders) {
                sounder.dispose();
            }
        }
    }

    public static class Conditional
    extends Implementation {
        protected SounderConfig.Conditional _config;
        protected BooleanExpression.Evaluator[] _evaluators;
        protected Sounder[] _sounders;
        protected Sounder _defaultSounder;
        protected Sounder _sounder;

        public Conditional(AlContext ctx, Scope parentScope, SounderConfig.Conditional config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Conditional config) {
            this._config = config;
            this.updateFromConfig();
        }

        @Override
        public boolean loops() {
            for (Sounder sounder : this._sounders) {
                if (!sounder.loops()) continue;
                return true;
            }
            return this._defaultSounder.loops();
        }

        @Override
        public void start() {
            for (int ii = 0; ii < this._evaluators.length; ++ii) {
                if (!this._evaluators[ii].evaluate()) continue;
                this._sounder = this._sounders[ii];
                this._sounder.start();
                return;
            }
            this._sounder = this._defaultSounder;
            this._sounder.start();
        }

        @Override
        public void stop() {
            if (this._sounder != null) {
                this._sounder.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            return this._sounder != null && this._sounder.isPlaying();
        }

        @Override
        public void update() {
            if (this._sounder != null) {
                this._sounder.update();
            }
        }

        @Override
        public void scopeUpdated(ScopeEvent event) {
            super.scopeUpdated(event);
            this.updateFromConfig();
        }

        protected void updateFromConfig() {
            int ii;
            boolean wasPlaying = this.isPlaying();
            this._evaluators = new BooleanExpression.Evaluator[this._config.cases.length];
            for (int ii2 = 0; ii2 < this._evaluators.length; ++ii2) {
                this._evaluators[ii2] = this._config.cases[ii2].condition.createEvaluator(this);
            }
            Sounder[] osounders = this._sounders;
            this._sounders = new Sounder[this._config.cases.length];
            for (ii = 0; ii < this._sounders.length; ++ii) {
                Sounder sounder;
                this._sounders[ii] = sounder = osounders == null || osounders.length <= ii ? new Sounder(this._ctx, this, this._transform) : osounders[ii];
                sounder.setConfig(this._config.cases[ii].sounder);
            }
            if (osounders != null) {
                for (ii = this._sounders.length; ii < osounders.length; ++ii) {
                    osounders[ii].dispose();
                }
            }
            if (this._defaultSounder == null) {
                this._defaultSounder = new Sounder(this._ctx, this, this._transform);
            }
            this._defaultSounder.setConfig(this._config.defaultSounder);
            if ((wasPlaying || this._started.value && this.loops()) && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            for (Sounder sounder : this._sounders) {
                sounder.dispose();
            }
            if (this._defaultSounder != null) {
                this._defaultSounder.dispose();
            }
        }
    }

    public static class MetaStream
    extends BaseStream {
        protected SounderConfig.MetaStream _config;
        protected float[] _weights;

        public MetaStream(AlContext ctx, Scope parentScope, SounderConfig.MetaStream config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.MetaStream config) {
            this._config = config;
            super.setConfig(this._config);
            this._weights = new float[config.files.length];
            for (int ii = 0; ii < this._weights.length; ++ii) {
                this._weights[ii] = config.files[ii].weight;
            }
            if (this._started.value && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            return true;
        }

        @Override
        public void start() {
            if (this._ctx.getSoundManager().isInitialized()) {
                this.startNextStream(this._config.fadeIn);
            }
        }

        protected void startNextStream(float fadeIn) {
            int idx = RandomUtil.getWeightedIndex((float[])this._weights);
            if (idx == -1) {
                return;
            }
            SounderConfig.WeightedFile wfile = this._config.files[idx];
            if (wfile.file == null) {
                return;
            }
            try {
                this.startStream(this.createStream(wfile), fadeIn);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error opening stream.", new Object[]{"file", wfile.file, e});
            }
        }

        protected StackedStream createStream(final SounderConfig.WeightedFile wfile) throws IOException {
            return new BaseStream.TransformedStream(wfile.file, false, this._config.stack){
                protected float _remaining;
                protected boolean _transitioning;
                {
                    super(file, loop, stack);
                    this._remaining = Float.MAX_VALUE;
                }

                @Override
                protected void update(float time) {
                    float f;
                    super.update(time);
                    if (this._remaining == Float.MAX_VALUE || this._transitioning || this._fadeMode == Stream.FadeMode.OUT_DISPOSE) {
                        return;
                    }
                    this._remaining -= time;
                    if (f <= _config.crossFade) {
                        this.startNextStream(Math.max(this._remaining, 0.0f));
                        this._transitioning = true;
                    }
                }

                @Override
                protected float getCombinedGain() {
                    return super.getCombinedGain() * wfile.gain;
                }

                protected int populateBuffer(ByteBuffer buf) throws IOException {
                    int read = super.populateBuffer(buf);
                    if (read < buf.capacity() && this._remaining == Float.MAX_VALUE) {
                        int bytes = this._qlen * this.getBufferSize() - (this._source.isPlaying() ? this._source.getByteOffset() : 0) + Math.max(read, 0);
                        int samples = bytes / (this.getFormat() == 4353 ? 2 : 4);
                        this._remaining = (float)samples / (float)this.getFrequency();
                    }
                    return read;
                }
            };
        }
    }

    public static class Stream
    extends BaseStream {
        protected SounderConfig.Stream _config;

        public Stream(AlContext ctx, Scope parentScope, SounderConfig.Stream config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Stream config) {
            this._config = config;
            super.setConfig(this._config);
            if (this._started.value && config.loops() && !this.isPlaying()) {
                this.start();
            }
        }

        @Override
        public boolean loops() {
            return this._config.loops();
        }

        @Override
        public void start() {
            if (!this._ctx.getSoundManager().isInitialized()) {
                return;
            }
            SounderConfig.QueuedFile[] queue = this._config.queue;
            SounderConfig.QueuedFile first = queue[0];
            try {
                BaseStream.TransformedStream stream = new BaseStream.TransformedStream(first.file, first.loop, this._config.stack);
                for (int ii = 1; ii < queue.length; ++ii) {
                    SounderConfig.QueuedFile queued = queue[ii];
                    if (queued.file == null) continue;
                    stream.queueResource(queued.file, queued.loop);
                }
                this.startStream(stream, this._config.fadeIn);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error opening stream.", new Object[]{"file", first.file, e});
            }
        }
    }

    public static abstract class BaseStream
    extends Implementation {
        protected SounderConfig.BaseStream _config;
        protected StackedStream _stream;
        @Bound
        protected MutableFloat _streamGain;

        public BaseStream(AlContext ctx, Scope parentScope) {
            super(ctx, parentScope);
        }

        public void setConfig(SounderConfig.BaseStream config) {
            this._config = config;
        }

        @Override
        public void stop() {
            this.stopStream(this._config.fadeOut);
        }

        @Override
        public boolean isPlaying() {
            return this._stream != null && this._stream.isPlaying();
        }

        protected void startStream(StackedStream stream, float fadeIn) {
            this.stopStream(fadeIn);
            this._stream = stream;
            this._stream.setGain(this._config.gain * this._streamGain.value);
            Source source = this._stream.getSource();
            source.setSourceRelative(this._config.sourceRelative);
            source.setMinGain(this._config.minGain);
            source.setMaxGain(this._config.maxGain);
            source.setReferenceDistance(this._config.referenceDistance);
            source.setRolloffFactor(this._config.rolloffFactor);
            source.setMaxDistance(this._config.maxDistance);
            source.setPitch(this._config.pitch);
            source.setConeInnerAngle(this._config.coneInnerAngle);
            source.setConeOuterAngle(this._config.coneOuterAngle);
            source.setConeOuterGain(this._config.coneOuterGain);
            this._stream.push(fadeIn, !this._config.push);
        }

        protected void stopStream(float fadeOut) {
            if (this._stream == null) {
                return;
            }
            this._stream.pop(fadeOut);
            this._stream = null;
        }

        protected class TransformedStream
        extends StackedStream {
            protected Vector3f _direction;

            public TransformedStream(String file, boolean loop, String stack) throws IOException {
                super(BaseStream.this._ctx.getSoundManager(), file, loop, stack);
                this._direction = new Vector3f();
            }

            protected void update(float time) {
                this.setGain(this.getCombinedGain());
                super.update(time);
                if (this._state == 4114) {
                    this.updateSoundTransform();
                }
            }

            protected float getCombinedGain() {
                float base = BaseStream.this._config.gain * BaseStream.this._streamGain.value;
                if (!BaseStream.this._config.attenuate) {
                    return base;
                }
                Listener listener = BaseStream.this._ctx.getSoundManager().getListener();
                BaseStream.this._transform.update(1);
                Vector3f translation = BaseStream.this._transform.getTranslation();
                float dx = listener.getPositionX() - translation.x;
                float dy = listener.getPositionY() - translation.y;
                float dz = listener.getPositionZ() - translation.z;
                float ref = BaseStream.this._config.referenceDistance;
                float dist = FloatMath.clamp(FloatMath.sqrt(dx * dx + dy * dy + dz * dz), ref, BaseStream.this._config.maxDistance);
                return base * ref / (ref + BaseStream.this._config.rolloffFactor * (dist - ref));
            }

            protected void updateSoundTransform() {
                BaseStream.this._transform.update(1);
                Vector3f translation = BaseStream.this._transform.getTranslation();
                this._source.setPosition(translation.x, translation.y, translation.z);
                if (BaseStream.this._config.directional) {
                    BaseStream.this._transform.getRotation().transformUnitX(this._direction);
                    this._source.setDirection(this._direction.x, this._direction.y, this._direction.z);
                }
            }
        }
    }

    public static class VariableClip
    extends BaseClip {
        protected SounderConfig.VariableClip _config;

        public VariableClip(AlContext ctx, Scope parentScope, SounderConfig.VariableClip config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.VariableClip config) {
            this._config = config;
            super.setConfig(this._config);
            this.updateFromConfig();
        }

        @Override
        public boolean loops() {
            return this._config.loop;
        }

        @Override
        public void start() {
            float gain = this._config.gain.getValue();
            if (this._sound != null) {
                this._sound.setGain(gain);
                this._sound.setPitch(this._config.pitch.getValue());
            }
            this.playSound(gain);
        }

        @Override
        protected void updateFromConfig() {
            boolean wasPlaying = this.isPlaying();
            this._sound = this.getSound(this._config.file, this._sound);
            if ((wasPlaying || this._started.value && this._config.loop) && !this.isPlaying()) {
                this.start();
            }
        }
    }

    public static class MetaClip
    extends BaseClip {
        protected SounderConfig.MetaClip _config;
        protected Sound[] _sounds;
        protected float[] _weights;

        public MetaClip(AlContext ctx, Scope parentScope, SounderConfig.MetaClip config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.MetaClip config) {
            this._config = config;
            super.setConfig(this._config);
            this.updateFromConfig();
        }

        @Override
        public boolean loops() {
            return this._config.loop;
        }

        @Override
        public void start() {
            int idx = RandomUtil.getWeightedIndex((float[])this._weights);
            this._sound = this._sounds[idx];
            this.playSound(this._config.gain * this._config.files[idx].gain);
        }

        @Override
        protected void updateFromConfig() {
            int ii;
            boolean wasPlaying = this.isPlaying();
            Sound[] osounds = this._sounds;
            this._sounds = new Sound[this._config.files.length];
            this._weights = new float[this._config.files.length];
            for (ii = 0; ii < this._sounds.length; ++ii) {
                SounderConfig.PitchWeightedFile wfile = this._config.files[ii];
                this._sounds[ii] = this.getSound(wfile.file, wfile.gain, wfile.pitch, osounds != null && ii < osounds.length ? osounds[ii] : null);
                this._weights[ii] = wfile.weight;
            }
            if (osounds != null) {
                for (ii = this._sounds.length; ii < osounds.length; ++ii) {
                    Sound osound = osounds[ii];
                    if (osound == null) continue;
                    osound.stop();
                }
            }
            if ((wasPlaying || this._started.value && this._config.loop) && !this.isPlaying()) {
                this.start();
            }
        }
    }

    public static class Clip
    extends BaseClip {
        protected SounderConfig.Clip _config;

        public Clip(AlContext ctx, Scope parentScope, SounderConfig.Clip config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SounderConfig.Clip config) {
            this._config = config;
            super.setConfig(this._config);
            this.updateFromConfig();
        }

        @Override
        public boolean loops() {
            return this._config.loop;
        }

        @Override
        public void start() {
            this.playSound(this._config.gain);
        }

        @Override
        protected void updateFromConfig() {
            boolean wasPlaying = this.isPlaying();
            this._sound = this.getSound(this._config.file, this._sound);
            if ((wasPlaying || this._started.value && this._config.loop) && !this.isPlaying()) {
                this.start();
            }
        }
    }

    public static abstract class BaseClip
    extends Implementation {
        protected SounderConfig.Original _config;
        protected Sound _sound;
        protected Vector3f _vector = new Vector3f();

        public BaseClip(AlContext ctx, Scope parentScope) {
            super(ctx, parentScope);
        }

        public void setConfig(SounderConfig.Original config) {
            this._config = config;
        }

        @Override
        public void stop() {
            if (this._sound != null) {
                this._sound.stop();
            }
        }

        @Override
        public boolean isPlaying() {
            return this._sound != null && (this._sound.isPlaying() || this._sound.isPending());
        }

        @Override
        public void update() {
            if (this._sound != null) {
                this.updateSoundTransform();
            }
        }

        @Override
        public void scopeUpdated(ScopeEvent event) {
            super.scopeUpdated(event);
            this.updateFromConfig();
        }

        protected abstract void updateFromConfig();

        protected void playSound(float gain) {
            if (this._sound != null) {
                this.updateSoundTransform();
                SoundClipManager clipmgr = ScopeUtil.resolve(this._parentScope, "clipmgr", null, SoundClipManager.class);
                if (clipmgr != null && !this.loops()) {
                    clipmgr.playSound(this._sound, gain);
                } else {
                    this._sound.play(null, this.loops());
                }
            }
        }

        protected void updateSoundTransform() {
            this._transform.extractTranslation(this._vector);
            this._sound.setPosition(this._vector.x, this._vector.y, this._vector.z);
            if (this._config.directional) {
                this._transform.transformVector(Vector3f.UNIT_X, this._vector).normalizeLocal();
                this._sound.setDirection(this._vector.x, this._vector.y, this._vector.z);
            }
        }

        protected Sound getSound(String file, Sound sound) {
            return this.getSound(file, 1.0f, 1.0f, sound);
        }

        protected Sound getSound(String file, float gain, float pitch, Sound sound) {
            SoundGroup group = ScopeUtil.resolve(this._parentScope, "soundGroup", null, SoundGroup.class);
            if (sound == null || sound.getGroup() != group || sound.getBuffer() == null || !sound.getBuffer().getPath().equals(file)) {
                if (sound != null) {
                    sound.stop();
                }
                Sound sound2 = sound = file == null || group == null ? null : group.getSound(file);
            }
            if (sound != null) {
                sound.setGain(gain * this._config.getGain());
                sound.setSourceRelative(this._config.sourceRelative);
                sound.setMinGain(this._config.minGain);
                sound.setMaxGain(this._config.maxGain);
                sound.setReferenceDistance(this._config.referenceDistance);
                sound.setRolloffFactor(this._config.rolloffFactor);
                sound.setMaxDistance(this._config.maxDistance);
                sound.setPitch(pitch * this._config.getPitch());
                sound.setConeInnerAngle(this._config.coneInnerAngle);
                sound.setConeOuterAngle(this._config.coneOuterAngle);
                sound.setConeOuterGain(this._config.coneOuterGain);
            }
            return sound;
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        protected AlContext _ctx;
        @Bound
        protected Transform3D _transform;
        @Bound
        protected MutableBoolean _started;

        public Implementation(AlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }

        public boolean loops() {
            return false;
        }

        public abstract void start();

        public abstract void stop();

        public abstract boolean isPlaying();

        public void update() {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }

        @Override
        public void dispose() {
            super.dispose();
            this.stop();
        }
    }
}

