/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.openal.ClipBuffer;
import com.threerings.openal.Sound;
import com.threerings.openal.util.AlContext;
import java.util.ArrayList;

public class SoundClipManager {
    protected AlContext _ctx;
    protected ArrayList<SoundEntry> _sounds = Lists.newArrayList();
    protected Multiset<String> _counts = HashMultiset.create();
    protected static final float[] GAIN_LEVEL = new float[]{1.0f, 1.5f, 2.0f, 2.4f};
    protected static final float MIN_GAP = 0.05f;
    protected static final float MIN_STOP = 0.15f;

    public SoundClipManager(AlContext ctx) {
        this._ctx = ctx;
    }

    public void playSound(Sound sound, final float gain) {
        int ii;
        ClipBuffer buffer = sound.getBuffer();
        if (buffer == null) {
            return;
        }
        final String path = buffer.getPath();
        int count = this._counts.count((Object)path);
        boolean canStop = false;
        if (sound.isPlaying() || count > 0) {
            for (ii = this._sounds.size() - 1; ii >= 0; --ii) {
                SoundEntry entry = this._sounds.get(ii);
                if (sound.isPlaying()) {
                    if (entry.sound != sound) continue;
                    this._sounds.remove(ii);
                    this._counts.remove((Object)path);
                    --count;
                    ClydeLog.log.debug((Object)"ClipManager replaying sound", new Object[]{"path", path});
                    break;
                }
                if (entry.elapsed < 0.05f && StringUtil.equals((String)entry.sound.getBuffer().getPath(), (String)path)) {
                    ClydeLog.log.debug((Object)"ClipManager prevent same sound", new Object[]{"path", path});
                    return;
                }
                if (canStop || !(entry.elapsed > 0.15f) || !StringUtil.equals((String)entry.sound.getBuffer().getPath(), (String)path)) continue;
                canStop = true;
            }
        }
        if (count + 1 >= GAIN_LEVEL.length) {
            if (!canStop) {
                ClydeLog.log.debug((Object)"ClipManager prevent sound no popped", new Object[]{"path", path});
                return;
            }
            int nn = this._sounds.size();
            for (ii = 0; ii < nn; ++ii) {
                SoundEntry entry = this._sounds.get(ii);
                if (!StringUtil.equals((String)entry.sound.getBuffer().getPath(), (String)sound.getBuffer().getPath())) continue;
                this._sounds.remove(ii);
                this._counts.remove((Object)entry.sound.getBuffer().getPath());
                ClydeLog.log.debug((Object)"ClipManager sound popped", new Object[]{"path", path});
                break;
            }
        }
        this._counts.add((Object)path);
        sound.play(true, false, new Sound.StartObserver(){

            public void soundStarted(Sound sound) {
                if (sound == null) {
                    SoundClipManager.this._counts.remove((Object)path);
                    ClydeLog.log.debug((Object)"Failed to start sound", new Object[]{"path", path});
                    return;
                }
                SoundClipManager.this._sounds.add(new SoundEntry(sound, gain));
                int count = SoundClipManager.this._counts.count((Object)path);
                sound.setGain(gain * SoundClipManager.this.getGainModifier(count));
                ClydeLog.log.debug((Object)"ClipManager play sound", new Object[]{"count", count, "path", path});
            }
        });
    }

    public void tick(float elapsed) {
        for (int ii = this._sounds.size() - 1; ii >= 0; --ii) {
            SoundEntry entry = this._sounds.get(ii);
            if (!entry.sound.isPlaying()) {
                this._sounds.remove(ii);
                this._counts.remove((Object)entry.sound.getBuffer().getPath());
                ClydeLog.log.debug((Object)"ClipManager sound ended", new Object[]{"path", entry.sound.getBuffer().getPath()});
                continue;
            }
            entry.elapsed += elapsed;
            int count = this._counts.count((Object)entry.sound.getBuffer().getPath());
            entry.sound.setGain(entry.gain * this.getGainModifier(count));
        }
    }

    protected float getGainModifier(int count) {
        return this._ctx.getSoundManager().getBaseGain() * GAIN_LEVEL[count - 1] / (float)count;
    }

    protected class SoundEntry {
        public Sound sound;
        public float gain;
        public float elapsed;

        public SoundEntry(Sound sound, float gain) {
            this.sound = sound;
            this.gain = gain;
        }
    }
}

