/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.Clip;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.OggStreamDecoder;
import com.threerings.resource.ResourceManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.WaveData;

public class ResourceClipProvider
implements ClipProvider {
    protected ResourceManager _rsrcmgr;

    public ResourceClipProvider(ResourceManager rsrcmgr) {
        this._rsrcmgr = rsrcmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clip loadClip(String path) throws IOException {
        InputStream in = this._rsrcmgr.getResource(path);
        if (path.endsWith(".ogg")) {
            try {
                Clip clip = ResourceClipProvider.loadOggClip(in);
                return clip;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        WaveData data = WaveData.create((InputStream)in);
        if (data == null) {
            throw new IOException("Error loading " + path);
        }
        return new Clip(data);
    }

    protected static Clip loadOggClip(InputStream in) throws IOException {
        int read;
        OggStreamDecoder decoder = new OggStreamDecoder();
        decoder.init(in);
        Clip clip = new Clip();
        clip.format = decoder.getFormat();
        clip.frequency = decoder.getFrequency();
        ByteBuffer buf = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = decoder.read(buf)) > 0) {
            out.write(buf.array(), 0, read);
            buf.clear();
        }
        byte[] bytes = out.toByteArray();
        clip.data = BufferUtils.createByteBuffer((int)bytes.length);
        clip.data.put(bytes).rewind();
        return clip;
    }
}

